/* ñ٤׻ */
#if 0		/* Patched by G-HAL */
#include <stdlib.h>
#include "mkdic.h"
#else
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_MALLOC_H)
# include <malloc.h>
#endif
#if !defined(__STDC_LIMIT_MACROS)
# define __STDC_LIMIT_MACROS
#endif
#if !defined(__STDC_CONSTANT_MACROS)
# define __STDC_CONSTANT_MACROS
#endif
#if defined(HAVE_STDINT_H)
# include <stdint.h>
#endif
#if !defined(__STDC_FORMAT_MACROS)
# define __STDC_FORMAT_MACROS
#endif
#if defined(HAVE_INTTYPES_H)
# include <inttypes.h>
#endif
#if defined(HAVE_STDIO_H)
# include <stdio.h>
#endif
#if defined(HAVE_STRING_H)
# include <string.h>
#endif
#if defined(HAVE_STRINGS_H)
# include <strings.h>
#endif
#if defined(HAVE_ERRNO_H)
# include <errno.h>
#endif

#include "src-diclib/alternative_mergesort.h"	/* Patched by G-HAL, Sun,02 Nov,2008 */
#if defined(DEBUG)				/* Patched by G-HAL, Wed,27 May,2009 */
# include "anthy/logger.h"
#endif
#include "src-worddic/dic_main.h"	/* Patched by G-HAL, Sat,22 Nov,2008 */
#include "mkdic.h"
#endif

static int
count_nr_words(struct yomi_entry_list *yl)
{
  int nr = 0;
  struct yomi_entry *ye;
  for (ye = yl->head; ye; ye = ye->next) {
    nr += ye->nr_entries;
  }
  return nr;
}

static struct word_entry **
make_word_array(struct yomi_entry_list *yl, int nr)
{
  struct word_entry **array = (struct word_entry**) malloc(sizeof(struct word_entry *) *
				    nr);
  int nth = 0;
  struct yomi_entry *ye;
  for (ye = yl->head; ye; ye = ye->next) {
    int i;
    for (i = 0; i < ye->nr_entries; i++) {
      array[nth] = &ye->entries[i];
      nth ++;
    }
  }
  return array;
}

/** qsortѤӴؿ */
static int
compare_word_entry_by_freq(const void *p1, const void *p2)
{
 #if 0		/* Patched by G-HAL, Sat,01 Nov,2008 */
  const struct word_entry * const *e1 = (const struct word_entry* const*) p1;
  const struct word_entry * const *e2 = (const struct word_entry* const*) p2;
  return abs((*e2)->raw_freq) - abs((*e1)->raw_freq);
 #else
  const struct word_entry* const* const e1 = (const struct word_entry* const* const) p1;
  const struct word_entry* const* const e2 = (const struct word_entry* const* const) p2;
  return abs((*e2)->raw_freq) - abs((*e1)->raw_freq);
 #endif
}

static void
set_freq(struct word_entry **array, int nr)
{
 #if 0		/* Patched by G-HAL, Sat,22 Nov,2008, Wed,27 May,2009 */
  int i;
  int percent = nr / 100;
  for (i = 0; i < nr; i++) {
    struct word_entry *we = array[i];
    we->freq = 99 - (i / percent);
    if (we->freq < 1) {
      we->freq = 1;
    }
    we->freq *= 100;
    we->freq -= we->source_order;
    if (we->raw_freq < 0) {
      we->freq *= -1;
    }
  }
 #else
  static const int freq_lower_limit = 100;
  int i;
  for (i = 0; i < nr; ++i) {
    struct word_entry* const we = array[i];
   #if defined(DEBUG)
    if ((INT16_MAX / FREQ_RATIO) < (abs(we->raw_freq))) {
      anthy_log( 1, "set_freq(): freq is overflow :%d.\n", we->raw_freq );
    }
   #endif
    we->freq = abs( we->raw_freq ) * freq_lower_limit;
    if (we->freq < freq_lower_limit) {
      we->freq = freq_lower_limit;
    }
    if (we->raw_freq < 0) {
      we->freq = - we->freq;
    }
  }
  return;
 #endif
}

void
calc_freq(struct yomi_entry_list *yl)
{
  int nr;
  struct word_entry **we;
  /**/
  nr = count_nr_words(yl);
  we = make_word_array(yl, nr);
  /**/
 #if 0	/* Patched by G-HAL, Sun,02 Nov,2008, Mon,05 Jan,2009, Wed,24 Jun,2009 */
  qsort(we, nr,
	sizeof(struct word_entry *),
	compare_word_entry_by_freq);
 #else
  if (1 < nr) {
    const int ret = mergesort( we, nr, sizeof(struct word_entry *), compare_word_entry_by_freq );
    if (0 != ret) {
      anthy_log( 1, "BUG: calc_freq(): mergesort(): %d:'%s'\n", errno, strerror(errno) );
      abort();
    }
  } else {
   #if defined(DEBUG) && (1 <= DEBUG)
    anthy_log( 1, "calc_freq(): mergesort(): %d.\n", nr );
   #endif
  }
 #endif
  set_freq(we, nr);
  /**/
  free(we);
}
/* vim:ts=8 sw=2 nomodified:
 */
