/*
 * ʻη wtype_t 򰷤
 *
 * ñʻ򰷤
 * ñϼǤġ
 * *ʻ
 * *ʻ쥵֥
 * *ʻ쥵֥֥
 * *ѥ饹(CC)
 * *ѷ
 * *Ω줫ɤΥե饰
 * wtype_tϾ嵭ξ򤹤٤ƴޤࡣ
 *
 * Ǥξܺ٤ˤĤƤ doc/POS򻲾Ȥ٤
 */
#ifndef _wtype_h_included_
#define _wtype_h_included_

#ifdef __cplusplus
extern "C" {
#endif


/*ʻ Part Of Speech */
#define POS_NONE 0
 /* ̾ */
#define POS_NOUN 1
 /* (Ի?) */
#define POS_PRT 2
#define POS_XV 3
 /* ư */
#define POS_V 4
 /* ƻ */
#define POS_A 5
 /* ư */
#define POS_AJV 6
 /*  */
#define POS_AV 7
 /* Ϣλ */
#define POS_ME 8
 /* ³ */
#define POS_CONJ 9
 /* () */
#define POS_IJ 10
 /* Ƭ */
#define POS_PRE 11
 /*  */
#define POS_SUC 12
 /* ñ */
#define POS_TANKANJI 13
 /* ̾դ̾첽 */
#define POS_N2T 14
 /* ưϢѷդƻ첽 */
#define POS_D2KY 15
 /*  */
#define POS_NUMBER 16
#define POS_INVAL 17
 /*  */
#define POS_OPEN 18
 /* Ĥ */
#define POS_CLOSE 19
 /*  */
#define POS_KIGOU 20

/* ѷ Conjugate Type */
#define CT_NONE 0
#define CT_SYUSI 1
#define CT_MIZEN 2
#define CT_RENYOU 3
#define CT_RENTAI 4
#define CT_KATEI 5
#define CT_MEIREI 6
 /* 촴 */
#define CT_HEAD 7
 /* ưϢѷ̾첽 */
#define CT_MEISIKA 8

/* ưγѥ饹 Conjugate Class */
#define CC_NONE 0
 /* Ը */
#define CC_K5 1
 /* Ը(Ԥ) */
#define CC_C5 2
 /* Ը */
#define CC_G5 3
 /* Ը */
#define CC_S5 4
 /* Ը */
#define CC_T5 5
 /* ʹԸ */
#define CC_N5 6
 /* ޹Ը */
#define CC_M5 7
 /* йԸ */
#define CC_B5 8
 /* Ը */
#define CC_R5 9
 /* Ը(ä) */
#define CC_L5 10
 /* Ը */
#define CC_W5 11
 /* Ը() */
#define CC_U5 12
 /* 岼 */
#define CC_KS1 13
 /*  */
#define CC_RV 14
 /*  */
#define CC_KV 15
 /* (֤װʳ) */
#define CC_SV 16
 /*  */
#define CC_ZV 17
 /* () */
#define CC_SRV 18
 /* Ѥȡ֤פϡѷηǼϿƤꡢġ
  * ƱѷʣɤߤΤ롣̤
  * ˡ֤2פ롣
  * (ʻפFLAGSǤ϶̤Ǥʤä) by vagus */
 /* () 2  add by vagus */
#define CC_SRV2 19
 /*  2  add by vagus */
#define CC_KV2 20
 /* ư */
#define CC_AJV 21
 /* ƻ쥯  add by vagus */
#define CC_A_KU 22
 /* ƻ쥷  add by vagus */
#define CC_A_SIKU 23
 /* ƻ쥦 */
#define CC_A_U 24
 /* ƻ쥨  add by vagus */
#define CC_A_E 25
 /* ƻ쥤  add by vagus */
#define CC_A_I 26
 /* ƻ֤ add by vagus */
#define CC_A_ii 27
 /* ƻ֤ʤ add by vagus */
#define CC_A_nai 28
 /* ƻ֤褤 add by vagus */
#define CC_A_yoi 29
 /* Ϣ󤺡 add by vagus */
#define CC_RZ 30

/* ʻ Class Of Speech */
#define COS_NONE 0
 /* ̾ */
#define COS_CN 1
 /*  */
#define COS_NN 2
 /* ̾ */
#define COS_JN 3
 /* ̾ */
#define COS_KK 4
 /* Ƭ */
#define COS_SUFFIX 5
 /* Ѥ */
#define COS_SVSUFFIX 6
/**/

/* ʻ Sub Class Of Speech*/
#define SCOS_NONE 0
#define SCOS_FAMNAME 1
#define SCOS_FSTNAME 2
#define SCOS_T0 10
#define SCOS_T1 11
#define SCOS_T2 12
#define SCOS_T3 13
#define SCOS_T4 14
#define SCOS_T5 15
#define SCOS_T6 16
#define SCOS_T7 17
#define SCOS_T8 18
#define SCOS_T9 19
#define SCOS_T10 20
#define SCOS_T11 21
#define SCOS_T12 22
#define SCOS_T13 23
#define SCOS_T14 24
#define SCOS_T15 25
#define SCOS_T16 26
#define SCOS_T17 27
#define SCOS_T18 28
#define SCOS_T19 29
#define SCOS_T20 30
#define SCOS_T21 31
#define SCOS_T22 32
#define SCOS_T23 33
#define SCOS_T24 34
#define SCOS_T25 35
#define SCOS_T26 36
#define SCOS_T27 37
#define SCOS_T28 38
#define SCOS_T29 39
#define SCOS_T30 40
#define SCOS_T31 41
#define SCOS_T32 42
#define SCOS_T33 43
#define SCOS_T34 44
#define SCOS_T35 45
#define SCOS_T36 46
#define SCOS_T37 47
#define SCOS_T38 48
#define SCOS_T39 49
#define SCOS_T40 50
#define SCOS_F0 60
#define SCOS_F1 61
#define SCOS_F2 62
#define SCOS_F3 63
#define SCOS_F4 64
#define SCOS_F5 65
#define SCOS_F6 66
#define SCOS_F7 67
#define SCOS_F8 68
#define SCOS_F9 69
#define SCOS_F10 70
#define SCOS_F11 71
#define SCOS_F12 72
#define SCOS_F13 73
#define SCOS_F14 74
 /* ƻ */
#define SCOS_A0 80
 /* ƻ첽 */
#define SCOS_A1 81
#define SCOS_N1 90
#define SCOS_N10 91
#define SCOS_N100 92
#define SCOS_N1000 93
#define SCOS_N10000 94

/* FLAGS */
#define WF_NONE 0
 /* ưϢѷ̾첽 */
#define WF_MEISI 1
 /* ̾ */
#define WF_SV 2
 /* Ω졢ʸΥȤʤ */
#define WF_INDEP 4
 /* ư */
#define WF_AJV 8

/* wtype_tΥեå */
#define WT_POS 0
#define WT_COS 1
#define WT_SCOS 2
#define WT_CC 3
#define WT_CT 4
#define WT_FLAGS 5

/* bit field */
#define POS_BITS 5
#define COS_BITS 4
#define SCOS_BITS 7
#define CC_BITS 5
#define CT_BITS 4
#define WF_BITS 4
/* 29bits */

/** ʻ */
struct wtype{
  unsigned int pos  : POS_BITS;
  unsigned int cos  : COS_BITS;
  unsigned int scos : SCOS_BITS;
  unsigned int cc   : CC_BITS;
  unsigned int ct   : CT_BITS;
  unsigned int wf   : WF_BITS;
};

typedef struct wtype wtype_t;

#if 0		/* Patched by G-HAL, Wed,05 Oct,2011 - Fri,07 Oct,2011 */
/** anthy_wtype_include(̾졢̾)Ͽդϵ */
extern int anthy_wtype_include(wtype_t haystack, wtype_t needle);

/* Ĥʻ줬˰פ뤫ɤ򸫤 */
extern int anthy_wtype_equal(wtype_t lhs, wtype_t rhs);

extern void anthy_print_wtype(wtype_t w);
/* ե̾ʻ(ؿ̾) */
extern const char *anthy_type_to_wtype(const char *name, wtype_t *w);
/* ʻ̾ʻ */
extern wtype_t anthy_init_wtype_by_name(const char *str);

extern int anthy_wtype_get_pos(wtype_t w);
extern int anthy_wtype_get_cc(wtype_t w);
extern int anthy_wtype_get_ct(wtype_t w);
extern int anthy_wtype_get_cos(wtype_t w);
extern int anthy_wtype_get_scos(wtype_t w);
extern int anthy_wtype_get_wf(wtype_t w);

/* ե饰μ */
extern int anthy_wtype_get_indep(wtype_t w);
extern int anthy_wtype_get_sv(wtype_t w);
extern int anthy_wtype_get_meisi(wtype_t w);
extern int anthy_wtype_get_ajv(wtype_t w);

extern wtype_t anthy_get_wtype(int pos, int cos, int scos, int cc, int ct, int wf);
extern wtype_t anthy_get_wtype_with_ct(wtype_t base, int ct);

extern void anthy_wtype_set_pos(wtype_t *w, int pos);
extern void anthy_wtype_set_cc(wtype_t *w, int cc);
extern void anthy_wtype_set_ct(wtype_t *w, int ct);
extern void anthy_wtype_set_cos(wtype_t *w, int cs);
extern void anthy_wtype_set_scos(wtype_t *w, int scos);
extern void anthy_wtype_set_dep(wtype_t *w, int isDep);
#elif 0
/* Τ饤ŸƤʤ
 * ../../anthy/wtype.h:312: sorry, unimplemented: inlining failed in call to 'anthy_wtype_include': function not considered for inlining
 * ../../src-worddic/word_dic.c:684: sorry, unimplemented: called from here
 * Υ顼ˤʤ롣
 * ȡΤ饤ŸޥŸ®
 */

/** anthy_wtype_include(̾졢̾)Ͽդϵ */
static inline int anthy_wtype_include( const wtype_t haystack, const wtype_t needle )
{
  /*printf("POS %d,%d\needle", haystack.type[WT_POS], needle.type[WT_POS]);*/
  if (haystack.pos != POS_NONE &&
      haystack.pos != needle.pos) {
    return 0;
  }
  if (haystack.cc != CC_NONE &&
      haystack.cc != needle.cc) {
    return 0;
  }
  if (haystack.ct != CT_NONE &&
      haystack.ct != needle.ct) {
    return 0;
  }
  if (haystack.cos != COS_NONE &&
      haystack.cos != needle.cos) {
    return 0;
  }
  if (haystack.scos != SCOS_NONE &&
      haystack.scos != needle.scos) {
    return 0;
  }
  return 1;
}

/* Ĥʻ줬˰פ뤫ɤ򸫤 */
static inline int anthy_wtype_equal( const wtype_t lhs, const wtype_t rhs )
{
  if (lhs.pos == rhs.pos &&
      lhs.cos == rhs.cos &&
      lhs.scos == rhs.scos &&
      lhs.cc == rhs.cc &&
      lhs.ct == rhs.ct &&
      lhs.wf == rhs.wf) {
    return 1;
  } else {
    return 0;
  }
}

extern void anthy_print_wtype( wtype_t w );
/* ե̾ʻ(ؿ̾) */
extern const char* anthy_type_to_wtype( const char* const name, wtype_t* const w );
/* ʻ̾ʻ */
extern wtype_t anthy_init_wtype_by_name( const char* const name );

static inline int anthy_wtype_get_pos( const wtype_t w )
{
  return w.pos;
}
static inline int anthy_wtype_get_cc( const wtype_t w )
{
  return w.cc;
}
static inline int anthy_wtype_get_ct( const wtype_t w )
{
  return w.ct;
}
static inline int anthy_wtype_get_cos( const wtype_t w )
{
  return w.cos;
}
static inline int anthy_wtype_get_scos( const wtype_t w )
{
  return w.scos;
}
static inline int anthy_wtype_get_wf( const wtype_t w )
{
  return w.wf;
}

/* ե饰μ */
static inline int anthy_wtype_get_indep( const wtype_t w )
{
  return w.wf & WF_INDEP;
}
static inline int anthy_wtype_get_sv( const wtype_t w )
{
  return w.wf & WF_SV;
}
static inline int anthy_wtype_get_meisi( const wtype_t w )
{
  return w.wf & WF_MEISI;
}
static inline int anthy_wtype_get_ajv( const wtype_t w )
{
  return w.wf & WF_AJV;
}

#if 0		/* Patched by G-HAL, Fri,07 Oct,2011 */
static inline wtype_t anthy_get_wtype( const int pos, const int cos, const int scos, const int cc, const int ct, const int wf )
{
  wtype_t w;

  w.pos = pos;
  w.cos = cos;
  w.scos = scos;
  w.cc = cc;
  w.ct = ct;
  w.wf = wf;

  return w;
}
static inline wtype_t anthy_get_wtype_with_ct( const wtype_t base, const int ct )
{
  wtype_t w;

  w = base;
  w.ct = ct;

  return w;
}
#else
static inline void anthy_get_wtype( wtype_t* const w, const int pos, const int cos, const int scos, const int cc, const int ct, const int wf )
{
  w->pos = pos;
  w->cos = cos;
  w->scos = scos;
  w->cc = cc;
  w->ct = ct;
  w->wf = wf;
  return;
}
static inline void anthy_get_wtype_with_ct( wtype_t* const w, const wtype_t base, const int ct )
{
  *w = base;
  w->ct = ct;
  return;
}
#endif

static inline void anthy_wtype_set_pos( wtype_t* const w, const int pos )
{
  w->pos = pos;
  return;
}
static inline void anthy_wtype_set_cc( wtype_t* const w, const int cc )
{
  w->cc = cc;
  return;
}
static inline void anthy_wtype_set_ct( wtype_t* const w, const int ct )
{
  w->ct = ct;
  return;
}
static inline void anthy_wtype_set_cos( wtype_t* const w, const int cs )
{
  w->cos = cs;
  return;
}
static inline void anthy_wtype_set_scos( wtype_t* const w, const int scos )
{
  w->scos = scos;
  return;
}
static inline void anthy_wtype_set_dep( wtype_t* const w, const int isDep )
{
  if (isDep) {
    w->wf &= (~WF_INDEP);
  }else{
    w->wf |= WF_INDEP;
  }
  return;
}
#else
/** anthy_wtype_include(̾졢̾)Ͽդϵ */
#define anthy_wtype_include( haystack, needle ) \
    (((POS_NONE != (haystack).pos) && ((haystack).pos != (needle).pos)) ? 0 \
     : (((CC_NONE != (haystack).cc) && ((haystack).cc != (needle).cc)) ? 0 \
       : (((CT_NONE != (haystack).ct) && ((haystack).ct != (needle).ct)) ? 0 \
         : (((COS_NONE != (haystack).cos) && ((haystack).cos != (needle).cos)) ? 0 \
           : (((SCOS_NONE != (haystack).scos) && ((haystack).scos != (needle).scos)) ? 0 \
             : 1)))))

/* Ĥʻ줬˰פ뤫ɤ򸫤 */
#define anthy_wtype_equal( lhs, rhs )	((((lhs).pos == (rhs).pos) && ((lhs).cos == (rhs).cos) && ((lhs).scos == (rhs).scos) && ((lhs).cc == (rhs).cc) && ((lhs).ct == (rhs).ct) && ((lhs).wf == (rhs).wf)) ? 1 : 0)

extern void anthy_print_wtype(wtype_t w);
/* ե̾ʻ(ؿ̾) */
extern const char* anthy_type_to_wtype( const char* const name, wtype_t* const w );
/* ʻ̾ʻ */
extern wtype_t anthy_init_wtype_by_name( const char* const name );

#define anthy_wtype_get_pos( w )		((w).pos)
#define anthy_wtype_get_cc( w )			((w).cc)
#define anthy_wtype_get_ct( w )			((w).ct)
#define anthy_wtype_get_cos( w )		((w).cos)
#define anthy_wtype_get_scos( w )		((w).scos)
#define anthy_wtype_get_wf( w )			((w).wf)

/* ե饰μ */
#define anthy_wtype_get_indep( w )		((w).wf & WF_INDEP)
#define anthy_wtype_get_sv( w )			((w).wf & WF_SV)
#define anthy_wtype_get_meisi( w )		((w).wf & WF_MEISI)
#define anthy_wtype_get_ajv( w )		((w).wf & WF_AJV)

#if 0		/* Patched by G-HAL, Fri,07 Oct,2011 */
extern wtype_t anthy_get_wtype(int pos, int cos, int scos, int cc, int ct, int wf);
extern wtype_t anthy_get_wtype_with_ct( wtype_t base, int ct );
#else
#define anthy_get_wtype( ret, p, o, s, c, t, w )	{ (ret)->pos = (p); (ret)->cos = (o); (ret)->scos = (s); (ret)->cc = (c); (ret)->ct = (t); (ret)->wf = (w); }
#define anthy_get_wtype_with_ct( ret, base, t )		{ *(ret) = (base); (ret)->ct = (t); }
#endif

#define anthy_wtype_set_pos( w, p )		((w)->pos = (p))
#define anthy_wtype_set_cc( w, c )		((w)->cc = (c))
#define anthy_wtype_set_ct( w, t )		((w)->ct = (t))
#define anthy_wtype_set_cos( w, o )		((w)->cos = (o))
#define anthy_wtype_set_scos( w, s )		((w)->scos = (s))
#define anthy_wtype_set_dep( w, isDep )		((isDep) ? ((w)->wf &= (~WF_INDEP)): ((w)->wf |= WF_INDEP))
#endif

extern void anthy_init_wtypes(void);

extern wtype_t anthy_wt_all;/* ٤Ƥ˥ޥå뼫Ω */
extern wtype_t anthy_wt_none;/* ʻ̵POS_INVAL */


#ifdef __cplusplus
}
#endif

#endif /* _wtype_h_included_ */
/* [ End of File ] */
/* vim:ts=8 sw=2 nomodified:
 */
