#ifndef _texttrie_h_included_
#define _texttrie_h_included_

#ifdef __cplusplus
extern "C" {
#endif


struct text_trie;

/* database manipulation */
extern struct text_trie *anthy_trie_open(const char *fn, int create);
extern void anthy_trie_close(struct text_trie *tt);
extern void anthy_trie_update_mapping(struct text_trie *tt);
/**/
extern int anthy_trie_add(struct text_trie *tt, const char *key, const char *body);
/* caller should free the result */
extern char *anthy_trie_find(struct text_trie *a, char *key);
extern void anthy_trie_delete(struct text_trie *tt, const char *key);
/**/
extern char *anthy_trie_find_next_key(struct text_trie *tt, char *buf, int len);
/**/
extern void anthy_trie_find_prefix(struct text_trie *tt, const char *str,
			    char *buf, int len,
			    int (*cb)(const char *key, const char *str));
/**/
extern void anthy_trie_print_array(struct text_trie *tt);


#ifdef __cplusplus
}
#endif

#endif /* _texttrie_h_included_ */
/* [ End of File ] */
/* vim:ts=8 sw=2 nomodified:
 */
