/* 򰷤 */
#ifndef _feature_set_h_included_
#define _feature_set_h_included_

#if 0		/* Patched by G-HAL */
#include <anthy/wtype.h>
#else
#include "anthy/wtype.h"
#include "anthy/splitter.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif


/* hash collisionФŬ䤹 */
#define WORD_HASH_MAX 1024

/**/
#define NR_EM_FEATURES 14

struct feature_list {
  /* ޤΤȤ14Ĥޤ */
  int nr;
  int size;
  union {
    short index[NR_EM_FEATURES];
    short *array;
  } u;
};

struct feature_freq {
  int f[NR_EM_FEATURES + 2];
};

#if 0		/* Patched by G-HAL, Wed,05 Oct,2011 - Fri,07 Oct,2011 */
extern void anthy_init_features(void);
extern struct feature_freq *
anthy_find_feature_freq(const void *array,
			const struct feature_list *fl,
			struct feature_freq *arg);
extern struct feature_freq *
anthy_find_array_freq(const void *array,
		      int *f, int nr,
		      struct feature_freq *arg);


/**/
extern void anthy_feature_list_init(struct feature_list *fl);
extern void anthy_feature_list_free(struct feature_list *fl);
/**/
extern void anthy_feature_list_add(struct feature_list *fl, int f);
extern int anthy_feature_list_nr(const struct feature_list *fl);
extern int anthy_feature_list_nth(const struct feature_list *fl, int nth);
extern void anthy_feature_list_sort(struct feature_list *fl);
/**/
extern void anthy_feature_list_set_cur_class(struct feature_list *fl, int cc);
extern void anthy_feature_list_set_class_trans(struct feature_list *fl, int pc, int cc);
extern void anthy_feature_list_set_dep_word(struct feature_list *fl, int h);
extern void anthy_feature_list_set_dep_class(struct feature_list *fl, int c);
extern void anthy_feature_list_set_noun_cos(struct feature_list *fl, wtype_t wt);
extern void anthy_feature_list_set_mw_features(struct feature_list *fl, int mask);
/**/
extern void anthy_feature_list_print(struct feature_list *fl);

#if 1	/* Patched by G-HAL, Mon,27 Sep,2010 */
extern int anthy_feature_list_cmp_wtype( wtype_t wt1, wtype_t wt2 );
#endif

#elif 0
/* Τ饤ŸƤʤ
 * ../../anthy/wtype.h:312: sorry, unimplemented: inlining failed in call to 'anthy_wtype_include': function not considered for inlining
 * ../../src-worddic/word_dic.c:684: sorry, unimplemented: called from here
 * Υ顼ˤʤ롣
 * ȡΤ饤ŸޥŸ®
 */

/* ֹ
 *
 * 0-19 饹
 * 30-319(30+SEG_SIZE^2) 饹°
 * 540-579 ¾
 * 580- (1024) °μ
 */
#define CUR_CLASS_BASE 0
#define DEP_TYPE_FEATURE_BASE 20
#define CLASS_TRANS_BASE 30
#define FEATURE_SV 542
#define FEATURE_WEAK 543
#define FEATURE_SUFFIX 544
#define FEATURE_NUM 546
#define FEATURE_CORE1 547
#define FEATURE_HIGH_FREQ 548
#define FEATURE_WEAK_SEQ 549
#define COS_BASE 573
#define DEP_FEATURE_BASE 580

extern void anthy_init_features( void );
extern struct feature_freq* anthy_find_feature_freq( const void* image, const struct feature_list* fl, struct feature_freq* arg );
extern struct feature_freq* anthy_find_array_freq( const void* array, int* f, int nr, struct feature_freq* arg );


static inline void anthy_feature_list_init( struct feature_list* const fl )
{
  fl->nr = 0;
  fl->size = NR_EM_FEATURES;
  return;
}
static inline void anthy_feature_list_free( _unused struct feature_list* const fl )
{
  return;
}

static inline void anthy_feature_list_add( struct feature_list* const fl, const int f )
{
  if (fl->nr < NR_EM_FEATURES) {
    fl->u.index[fl->nr] = f;
    fl->nr++;
  }
  return;
}
static inline int anthy_feature_list_nr( const struct feature_list* const fl )
{
  return fl->nr;
}
static inline int anthy_feature_list_nth( const struct feature_list* const fl, const int nth )
{
  return fl->u.index[nth];
}
extern void anthy_feature_list_sort( struct feature_list* fl );

static inline void anthy_feature_list_set_cur_class( struct feature_list* const fl, const int cl )
{
  anthy_feature_list_add( fl, (CUR_CLASS_BASE + cl) );
  return;
}
static inline void anthy_feature_list_set_class_trans( struct feature_list* const fl, const int pc, const int cc )
{
  anthy_feature_list_add( fl, (CLASS_TRANS_BASE + pc * SEG_SIZE + cc) );
  return;
}
static inline void anthy_feature_list_set_dep_word( struct feature_list* const fl, const int h )
{
  anthy_feature_list_add( fl, (h + DEP_FEATURE_BASE) );
  return;
}
static inline void anthy_feature_list_set_dep_class( struct feature_list* const fl, const int c )
{
  anthy_feature_list_add( fl, (c + DEP_TYPE_FEATURE_BASE) );
  return;
}
static inline void anthy_feature_list_set_noun_cos( struct feature_list* const fl, const wtype_t wt )
{
  if (POS_NOUN != anthy_wtype_get_pos(wt)) {
    return;
  }
  const int c = anthy_wtype_get_cos( wt );
  if (COS_SUFFIX == c) {
    anthy_feature_list_add( fl, (COS_BASE + c) );
  }
  return;
}
static inline void anthy_feature_list_set_mw_features( struct feature_list* const fl, const int mask )
{
  if (mask & MW_FEATURE_WEAK_CONN) {
    anthy_feature_list_add( fl, FEATURE_WEAK );
  }
  if (mask & MW_FEATURE_SUFFIX) {
    anthy_feature_list_add( fl, FEATURE_SUFFIX );
  }
  if (mask & MW_FEATURE_SV) {
    anthy_feature_list_add( fl, FEATURE_SV );
  }
  if (mask & MW_FEATURE_NUM) {
    anthy_feature_list_add( fl, FEATURE_NUM );
  }
  if (mask & MW_FEATURE_CORE1) {
    anthy_feature_list_add( fl, FEATURE_CORE1 );
  }
  if (mask & MW_FEATURE_HIGH_FREQ) {
    anthy_feature_list_add( fl, FEATURE_HIGH_FREQ );
  }
  if (mask & MW_FEATURE_WEAK_SEQ) {
    anthy_feature_list_add( fl, FEATURE_WEAK_SEQ );
  }
  return;
}

extern void anthy_feature_list_print(struct feature_list *fl);

static inline int anthy_feature_list_cmp_wtype( wtype_t wt1, wtype_t wt2 )
{
  if (POS_NOUN != anthy_wtype_get_pos(wt1)) {
    if (POS_NOUN != anthy_wtype_get_pos(wt2)) {
      return 0;
    } else {
      return -1;
    }
  } else {
    if (POS_NOUN != anthy_wtype_get_pos(wt2)) {
      return +1;
    } else {
      if (COS_SUFFIX != anthy_wtype_get_cos(wt1)) {
	if (COS_SUFFIX != anthy_wtype_get_cos(wt2)) {
	  return 0;
	} else {
	  return -1;
	}
      } else {
	if (COS_SUFFIX != anthy_wtype_get_cos(wt2)) {
	  return +1;
	} else {
	  return 0;
	}
      }
    }
  }
}
#else
/* ֹ
 *
 * 0-19 饹
 * 30-319(30+SEG_SIZE^2) 饹°
 * 540-579 ¾
 * 580- (1024) °μ
 */
#define CUR_CLASS_BASE 0
#define DEP_TYPE_FEATURE_BASE 20
#define CLASS_TRANS_BASE 30
#define FEATURE_SV 542
#define FEATURE_WEAK 543
#define FEATURE_SUFFIX 544
#define FEATURE_NUM 546
#define FEATURE_CORE1 547
#define FEATURE_HIGH_FREQ 548
#define FEATURE_WEAK_SEQ 549
#define COS_BASE 573
#define DEP_FEATURE_BASE 580

#define anthy_feature_list_init( fl ) \
{ (fl)->nr = 0; \
  (fl)->size = NR_EM_FEATURES; }
#define anthy_feature_list_free( fl )	{  }

#define anthy_feature_list_add( fl, f ) \
{ if ((fl)->nr < NR_EM_FEATURES) { \
  (fl)->u.index[(fl)->nr] = (f); \
  (fl)->nr++; \
				 } \
}
#define anthy_feature_list_nr( fl )				((fl)->nr)
#define anthy_feature_list_nth( fl, nth )			((fl)->u.index[(nth)])
extern void anthy_feature_list_sort( struct feature_list *fl );

#define anthy_feature_list_set_cur_class( fl, cl )		anthy_feature_list_add((fl), CUR_CLASS_BASE + (cl))
#define anthy_feature_list_set_class_trans( fl, pc, cc )	anthy_feature_list_add((fl), CLASS_TRANS_BASE + (pc) * SEG_SIZE + (cc))
#define anthy_feature_list_set_dep_word( fl, h )		anthy_feature_list_add((fl), (h) + DEP_FEATURE_BASE)
#define anthy_feature_list_set_dep_class( fl, c )		anthy_feature_list_add((fl), (c) + DEP_TYPE_FEATURE_BASE)
#define anthy_feature_list_set_noun_cos( fl, wt ) \
{ if (POS_NOUN == anthy_wtype_get_pos((wt))) { \
  int c = anthy_wtype_get_cos((wt)); \
  if (c == COS_SUFFIX) { \
    anthy_feature_list_add((fl), COS_BASE + c); \
  } \
					     } \
}
#define anthy_feature_list_set_mw_features( fl, mask ) \
{ \
  if ((mask) & MW_FEATURE_WEAK_CONN) { anthy_feature_list_add((fl), FEATURE_WEAK); } \
  if ((mask) & MW_FEATURE_SUFFIX)    { anthy_feature_list_add((fl), FEATURE_SUFFIX); } \
  if ((mask) & MW_FEATURE_SV)        { anthy_feature_list_add((fl), FEATURE_SV); } \
  if ((mask) & MW_FEATURE_NUM)       { anthy_feature_list_add((fl), FEATURE_NUM); } \
  if ((mask) & MW_FEATURE_CORE1)     { anthy_feature_list_add((fl), FEATURE_CORE1); } \
  if ((mask) & MW_FEATURE_HIGH_FREQ) { anthy_feature_list_add((fl), FEATURE_HIGH_FREQ); } \
  if ((mask) & MW_FEATURE_WEAK_SEQ)  { anthy_feature_list_add((fl), FEATURE_WEAK_SEQ); } \
}

extern void anthy_feature_list_print( struct feature_list *fl );

#define anthy_feature_list_cmp_wtype( wt1, wt2 ) \
    ((POS_NOUN != anthy_wtype_get_pos((wt1))) ? (POS_NOUN != anthy_wtype_get_pos((wt2)) ? 0 : -1) \
     : (POS_NOUN != anthy_wtype_get_pos((wt2)) ? +1 \
	: (COS_SUFFIX != anthy_wtype_get_cos((wt1)) ? (COS_SUFFIX != anthy_wtype_get_cos((wt2)) ? 0 : -1) \
	   : (COS_SUFFIX != anthy_wtype_get_cos((wt2)) ? +1 : 0))))

extern struct feature_freq* anthy_find_array_freq( const void *image, int *f, int nr, struct feature_freq *arg );
extern struct feature_freq* anthy_find_feature_freq( const void* const image, const struct feature_list* const fl, struct feature_freq *arg );

extern void anthy_init_features( void );
#endif


#ifdef __cplusplus
}
#endif

#endif /* _feature_set_h_included_ */
/* [ End of File ] */
/* vim:ts=8 sw=2 nomodified:
 */
