/**
 * @file
 * @brief readconf() 使用サンプル。
 * @author tsntsumi
 * @since v1.0 2013
 */
#include <stdio.h>
#include <stdlib.h>
#include "readconf.h"

static bool validatePortnoRange(char *name, RCValueType type, RCConfValue value);


RCConfItem SampleConfItems[] =
  {
    { "StringConf", RCValueTypeString, "default string" },
    { "NumberConf", RCValueTypeInteger, "14" },
    { "HexNumberConf", RCValueTypeInteger, "0x0000ffff" },
    { "OctalNumberConf", RCValueTypeInteger, "017" },
    { "RealNumberConf", RCValueTypeReal, "-.987e-1" },
    { "ValidateConf", RCValueTypeInteger, "50000", validatePortnoRange },
  };

enum SampleConfItemNo
  {
    StringConf = 0,
    NumberConf,
    HexNumberConf,
    OctalNumberConf,
    RealNumberConf,
    ValidateConf,
    NumSampleConfItem
  };

int main(int argc, char *argv[])
{
  int i, j, k;

  if (argc < 1)
    {
      printf("sample CONFFILE...\n");
      exit(EXIT_SUCCESS);
    }
  for (i = 1; i < argc; i ++)
    {
      readconf(SampleConfItems, ELEMENTSOF(SampleConfItems), argv[i]);
      for (j = 0; j < RCNumRaisedErrors; j ++)
	{
	  printf("%s:%lu: %s\n", 
		 argv[i], RCRaisedErrors[j].lineNo, RCRaisedErrors[j].reason);
	}
      for (k = 0; k < ELEMENTSOF(SampleConfItems); k ++)
	{
	  if (SampleConfItems[k].type == RCValueTypeString)
	    {
	      printf("%s: %s = \"%s\" (default:%s)\n",
		     argv[0],
		     SampleConfItems[k].name,
		     SampleConfItems[k].value.string,
		     SampleConfItems[k].defaultAsString);
	    }
	  else if (SampleConfItems[k].type == RCValueTypeInteger)
	    {
	      printf("%s: %s = %ld (0x%lx, %03lo) (default:%s)\n",
		     argv[0],
		     SampleConfItems[k].name,
		     SampleConfItems[k].value.integer,
		     SampleConfItems[k].value.integer,
		     SampleConfItems[k].value.integer,
		     SampleConfItems[k].defaultAsString);
	    }
	  else if (SampleConfItems[k].type == RCValueTypeReal)
	    {
	      printf("%s: %s = %g (default:%s)\n",
		     argv[0],
		     SampleConfItems[k].name,
		     SampleConfItems[k].value.real,
		     SampleConfItems[k].defaultAsString);
	    }
	}
      RCFreeStringValueInItems(SampleConfItems, ELEMENTSOF(SampleConfItems));
      RCFreeRaisedErrors();
    }
  return EXIT_SUCCESS;
}

static bool validatePortnoRange(char *name, RCValueType type, RCConfValue value)
{
  if (value.integer < 40960)
    {
      return false;
    }
  if (value.integer > 65535)
    {
      return false;
    }
  return true;
}
