import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.LinkedList;
import java.util.Queue;
import bindata.*;

public class BinToTextConverter {
	
	protected static final String BINARY_FILE_NAME = "b2tconv.bin";
	protected static final String TEXT_FILE_NAME = "b2tconv.txt";
	
	private Queue<String> textData = new LinkedList<String>();
	// private Queue<BinaryDatum> binaryData = new LinkedList<BinaryDatum>();
	
	public static void main(String[] args) {
		BinToTextConverter binToTextConverter = new BinToTextConverter();
		binToTextConverter.createBinaryData();
		binToTextConverter.convertBinaryToText();
		binToTextConverter.saveTextData();
	}
	
	private void createBinaryData() {
		File binaryFile = new File(BINARY_FILE_NAME);
		try (OutputStream os = Files.newOutputStream(binaryFile.toPath(), StandardOpenOption.WRITE);
				BufferedOutputStream outStream = new BufferedOutputStream(os)) {
			byte[] binaryDatum = new byte[15];
			long startTime = System.nanoTime() / 1000;
			for (int i = 0; i < 1000; i ++) {
				long elapsedTime = System.nanoTime() / 1000 - startTime;
				binaryDatum[0] = 12;
				binaryDatum[1] = 48;
				binaryDatum[2] = 15;
				binaryDatum[3] = (byte) ((elapsedTime & 0xFF0000) >> 16);
				binaryDatum[4] = (byte) ((elapsedTime & 0xFF00) >> 8);
				binaryDatum[5] = (byte) (elapsedTime & 0xFF);
				for (int j = 0; j < 8; j ++) {
					binaryDatum[6 + j] = (byte) j; 
				}
				int sum = 0;
				for (int j = 0; j < 14; j ++) {
					sum += binaryDatum[j];
				}
				binaryDatum[14] = (byte) (sum & 0xFF);
				outStream.write(binaryDatum);
			}
		}
		catch (FileNotFoundException e) {
			System.out.println("cannot found output file " + BINARY_FILE_NAME + ".");
		}
		catch (IOException e) {
			System.out.println("cannot output binary data.");
		}
	}
	
	private void convertBinaryToText() {
		File binaryFile = new File(BINARY_FILE_NAME);
		try (InputStream inStream = Files.newInputStream(binaryFile.toPath(), StandardOpenOption.READ)) {
			byte[] inBuffer = new byte[154];
			BinaryDatum datum = new BinaryDatum();
			int numData = 0;
			int count = 0;
			long startTime = System.nanoTime();
			while ((count = inStream.read(inBuffer)) != -1) {
				for (int i = 0; i < count; i ++) {
					datum.append(inBuffer[i]);
					if (datum.isComplete()) {
						textData.offer(datum.toString());
						// binaryData.offer(new BinaryDatum(datum));
						// binaryData.offer(datum);
						numData ++;
						datum.clear();
						// datum = new BinaryDatum();
					}
				}
			}
			long endTime = System.nanoTime();
			System.out.println("start:  " + startTime + " ns");
			System.out.println("end:    " + endTime + " ns");
			System.out.println("elapsed:" + ((endTime - startTime) / 1000000.0f) + " ms");
			System.out.println("" + numData + " data.");
		}
		catch (FileNotFoundException e) {
			System.out.println("cannot found input file " + BINARY_FILE_NAME + ".");
		}
		catch (IOException e) {
			System.out.println("cannot read binary data.");
		}
	}
	
	private void saveTextData() {
		File textFile = new File(TEXT_FILE_NAME);
		try (BufferedWriter bw = Files.newBufferedWriter(textFile.toPath(),
														 StandardOpenOption.WRITE,
														 StandardOpenOption.TRUNCATE_EXISTING);
				PrintWriter outWriter = new PrintWriter(bw)) {
			for (String each : textData) {
				outWriter.println(each);
			}
			/*
			for (BinaryDatum each : binaryData) {
				outWriter.println(each.toString());
			}
			*/
		}
		catch (FileNotFoundException e) {
			System.out.println("cannot found output file " + TEXT_FILE_NAME + ".");
		}
		catch (IOException e) {
			System.out.println("cannot write text file.");
		}
	}

}
