RVM Install Memo
================

previously installing ...
-------------------------

+ curl
+ curl-devel or libcurl
+ git (with ssh, like git-all)

curl fails as CA verification
-----------------------------

    curl: (60) SSL certificate problem, verify that the CA cert is OK. Details:
    error:14090086:SSL routines:SSL3_GET_SERVER_CERTIFICATE:certificate verify failed
    More details here: http://curl.haxx.se/docs/sslcerts.html

If curl's error like above was showed, the bundled CA cert file is old. Install new one.

    $ curl-config --ca                                             # show path to the certificate
    /usr/local/share/curl/curl-ca-bundle.crt
    $ cd /usr/local/share/curl/                                    # go to that path
    $ cp curl-ca-bundle.crt curl-ca-bundle.crt.bak                 # backup certificate
    $ curl http://curl.haxx.se/ca/cacert.pem -o curl-ca-bundle.crt # download new
    $ rvm install 1.9.2                                            # bingo it works


package compile options
-----------------------
### run install with compile options when install

    rvm install 1.9.2 --with-readline-dir=$rvm_path/usr \
                      --with-iconv-dir=$rvm_path/usr \
                      --with-zlib-dir=$rvm_path/usr \
                      --with-openssl-dir=$rvm_path/usr
### installing

    rvm pkg install readline
    rvm pkg install iconv
    rvm pkg install zlib
    rvm pkg install openssl
    rvm pkg install autoconf

<!-- vim: set ft=markdown :-->
