#!/usr/bin/env ruby
# coding:utf-8

module Ext
  module String
    def self.extended(base)
      base.send :include, self::InstanceMethods
    end

    module InstanceMethods
      def indent(shiftwidth=2)
        self.split("\n").map{|line| "\s" * shiftwidth + line}.join("\n")
      end

      # borrowed from active_support/inflectors
      def underscore
        acronym_regex = /(?=a)b/
        word = self.to_s.dup
        word.gsub!('::', '/')
        word.gsub!(/(?:([A-Za-z\d])|^)(#{acronym_regex})(?=\b|[^a-z])/) { "#{$1}#{$1 && '_'}#{$2.downcase}" }
        word.gsub!(/([A-Z\d]+)([A-Z][a-z])/,'\1_\2')
        word.gsub!(/([a-z\d])([A-Z])/,'\1_\2')
        word.tr!("-", "_")
        word.downcase!
        word
      end
    end
  end
end

