#!/usr/bin/env
# coding:utf-8

module Ext
  module Pathname
    def self.extended(base)
      base.send :include, self::InstanceMethods
    end

    module InstanceMethods
      def ext(new_ext)
        return self if self.directory?

        if to_s =~ /\.[^.]+$/
          sub(/\.[^.]+$/, new_ext)
        else
          self.class.new(to_s + new_ext)
        end
      end
    end
  end
end

