package mirrg.swing.helium;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;

import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class DialogMirrg extends JDialog
{

	public DialogMirrg()
	{
		super();
		initDialogMirrg();
	}

	public DialogMirrg(Dialog owner, boolean modal)
	{
		super(owner, modal);
		initDialogMirrg();
	}

	public DialogMirrg(Dialog owner, String title, boolean modal, GraphicsConfiguration gc)
	{
		super(owner, title, modal, gc);
		initDialogMirrg();
	}

	public DialogMirrg(Dialog owner, String title, boolean modal)
	{
		super(owner, title, modal);
		initDialogMirrg();
	}

	public DialogMirrg(Dialog owner, String title)
	{
		super(owner, title);
		initDialogMirrg();
	}

	public DialogMirrg(Dialog owner)
	{
		super(owner);
		initDialogMirrg();
	}

	public DialogMirrg(Frame owner, boolean modal)
	{
		super(owner, modal);
		initDialogMirrg();
	}

	public DialogMirrg(Frame owner, String title, boolean modal, GraphicsConfiguration gc)
	{
		super(owner, title, modal, gc);
		initDialogMirrg();
	}

	public DialogMirrg(Frame owner, String title, boolean modal)
	{
		super(owner, title, modal);
		initDialogMirrg();
	}

	public DialogMirrg(Frame owner, String title)
	{
		super(owner, title);
		initDialogMirrg();
	}

	public DialogMirrg(Frame owner)
	{
		super(owner);
		initDialogMirrg();
	}

	public DialogMirrg(Window owner, ModalityType modalityType)
	{
		super(owner, modalityType);
		initDialogMirrg();
	}

	public DialogMirrg(Window owner, String title, ModalityType modalityType, GraphicsConfiguration gc)
	{
		super(owner, title, modalityType, gc);
		initDialogMirrg();
	}

	public DialogMirrg(Window owner, String title, ModalityType modalityType)
	{
		super(owner, title, modalityType);
		initDialogMirrg();
	}

	public DialogMirrg(Window owner, String title)
	{
		super(owner, title);
		initDialogMirrg();
	}

	public DialogMirrg(Window owner)
	{
		super(owner);
		initDialogMirrg();
	}

	protected void initDialogMirrg()
	{

		addComponentListener(new ComponentListener() {

			@Override
			public void componentShown(ComponentEvent e)
			{

				if (enabledTick) {

					if (thread != null) {
						thread.interrupt();
						thread = null;
					}

					Thread thread = new Thread(() -> {

						while (isVisible()) {
							SwingUtilities.invokeLater(() -> {
								onTick.forEach(Runnable::run);
							});

							try {
								Thread.sleep(msTick);
							} catch (InterruptedException e2) {
								break;
							}

						}

					});
					thread.setDaemon(true);
					thread.start();

				}

				DialogMirrg.this.componentShown();

			}

			@Override
			public void componentResized(ComponentEvent e)
			{

			}

			@Override
			public void componentMoved(ComponentEvent e)
			{

			}

			@Override
			public void componentHidden(ComponentEvent e)
			{

				if (thread != null) {
					thread.interrupt();
					thread = null;
				}

			}

		});

	}

	protected void componentShown()
	{

	}

	protected Thread thread = null;
	protected boolean enabledTick = false;
	protected int msTick = 500;

	protected ArrayList<Runnable> onTick = new ArrayList<>();

}
