package mirrg.simulation.cart.almandine.mod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map.Entry;
import java.util.Optional;
import java.util.Set;

import mirrg.stream.HStream;

public class RegistryBase<T>
{

	private Hashtable<String, T> registry = new Hashtable<>();

	public void register(String modId, String name, T t)
	{
		registry.put(modId + ":" + name, t);
	}

	public Optional<T> get(String modId, String name)
	{
		return get(modId + ":" + name);
	}

	public Optional<T> get(String identifier)
	{
		return Optional.ofNullable(registry.get(identifier));
	}

	public Set<Entry<String, T>> entrySet()
	{
		return registry.entrySet();
	}

	public ArrayList<String> getKeys()
	{
		return HStream.of(registry.keys());
	}

	public Collection<T> getValues()
	{
		return registry.values();
	}

}
