package mirrg.simulation.cart.almandine.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

import mirrg.applet.nitrogen.AppletNitrogen;
import mirrg.applet.nitrogen.HAppletNitrogen;
import mirrg.applet.nitrogen.HAppletNitrogen.ResponceApplyStandard;
import mirrg.applet.nitrogen.events.NitrogenEventApplet;
import mirrg.applet.nitrogen.events.NitrogenEventGameThread;
import mirrg.applet.nitrogen.events.NitrogenEventKey;
import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.gui.toolcursor.NitrogenEventToolCursor;
import mirrg.simulation.cart.almandine.gui.toolcursor.RegistryToolCursor;
import mirrg.simulation.cart.almandine.gui.toolcursor.TabItem;
import mirrg.simulation.cart.almandine.gui.toolcursor.ToolCursor;

public class PanelAlmandine extends AppletNitrogen
{

	private IFrameGameAlmandine frameGameAlmandine;

	/**
	 * nonnull
	 */
	public ToolCursor toolCursor;

	public PanelAlmandine(IFrameGameAlmandine frameGameAlmandine)
	{
		this.frameGameAlmandine = frameGameAlmandine;
		ResponceApplyStandard responce = HAppletNitrogen.applyStandard(this);

		//

		// init
		{
			toolCursor = new ToolCursor(frameGameAlmandine) {

				@Override
				public String getLocalizedName()
				{
					return "なし";
				}

				@Override
				public String getLocalizedDescription()
				{
					return "";
				}

			};
		}

		// tick
		{
			getEventManager().register(NitrogenEventGameThread.Tick.class, event -> {

				frameGameAlmandine.getGame().tick();

				toolCursor.eventManager.post(new NitrogenEventToolCursor.Tick());

			});
		}

		// render
		{
			getEventManager().register(NitrogenEventGameThread.Render.class, event -> {
				responce.gameThread.objectiveFps = frameGameAlmandine.getGame().getFPS().value;
				repaint();
			});

			getEventManager().register(NitrogenEventApplet.Paint.class, event -> {

				renderAll(responce);

				responce.tripleBuffer.flip();

				event.graphics.drawImage(responce.tripleBuffer.getBufferSafety().getBuffer(), 0, 0, this);
			});
		}

		// input event
		{

			// tool cursor bridge
			getEventManager().register(Object.class, e -> {
				toolCursor.eventManager.post(e);
			});

			// shortcut key
			getEventManager().register(NitrogenEventKey.Released.class, e -> {
				RegistryToolCursor.instance.find(e.keyEvent)
					.ifPresent(TabItem::action);
			});

			// accelerator key
			getEventManager().register(NitrogenEventKey.class, e -> {
				frameGameAlmandine.getFrame().getContentPane().dispatchEvent(e.keyEvent);
			});

		}

		setPreferredSize(new Dimension(600, 600));
	}

	private void renderAll(ResponceApplyStandard responce)
	{
		Graphics2D graphics = responce.tripleBuffer.getBufferDirty().getGraphics();

		// 設定
		graphics.setTransform(new AffineTransform());
		graphics.setRenderingHint(
			RenderingHints.KEY_ANTIALIASING,
			RenderingHints.VALUE_ANTIALIAS_ON);
		graphics.setStroke(new BasicStroke(1));

		// clear
		graphics.setBackground(Color.white);
		graphics.clearRect(0, 0, getWidth(), getHeight());

		//

		// render factory
		frameGameAlmandine.getGame().render(graphics, frameGameAlmandine);

		// render toolCursor
		toolCursor.eventManager.post(new NitrogenEventToolCursor.Render(graphics));

		// render gui
		renderGUI(graphics, responce);

	}

	private DateTimeFormatter formatter = DateTimeFormatter.ofPattern("M月d日 H時m分s秒 SSS");

	private void renderGUI(Graphics2D graphics, ResponceApplyStandard responce)
	{
		graphics.setFont(new Font(Font.SANS_SERIF, Font.PLAIN, 14));
		int size = graphics.getFont().getSize();
		graphics.setColor(Color.black);

		int row = 1;

		// draw toolCursor text
		graphics.drawString(String.format(
			"カーソルツール: %s",
			toolCursor.getLocalizedName()),
			0, size * row);

		row++;

		graphics.drawString(String.format(
			"カーソルツール説明: %s",
			toolCursor.getLocalizedDescription()),
			0, size * row);

		row++;

		// draw simulation speed
		graphics.drawString(String.format(
			"TickPerFrame: %s, SecondPerTick: %s",
			frameGameAlmandine.getGame().getTickPerFrame().value,
			frameGameAlmandine.getGame().getSecondPerTick().value),
			0, size * row);

		row++;

		// draw time
		{
			Instant base = LocalDateTime.of(2000, 1, 1, 0, 0, 0).toInstant(ZoneOffset.UTC);
			LocalDateTime time = LocalDateTime.ofInstant(
				base.plusMillis((long) (frameGameAlmandine.getGame().getTime().value * 1000)),
				ZoneOffset.UTC);

			graphics.drawString(String.format(
				"時間: %s 年 %s",
				time.getYear() - 2000,
				time.format(formatter)),
				0, size * row);
		}

		// draw fps
		graphics.drawString(String.format(
			"FPS: %.2f",
			responce.fpsAdjuster.getFPS()),
			0, getHeight());
		graphics.drawString(String.format(
			"CPU: %.2f%%",
			responce.fpsAdjuster.getLoadFactor() * 100),
			0, getHeight() - size);

	}

}
