package mirrg.simulation.cart.almandine.factory;

import java.util.stream.Stream;

import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;

public abstract class Primary extends Entity
{

	@Deprecated
	public Primary()
	{
		super();
	}

	public Primary(GameAlmandine game)
	{
		super(game);
	}

	public boolean selected;

	@Override
	protected void addProperty(IDialogProperty dialogProperty)
	{
		super.addProperty(dialogProperty);

		dialogProperty.addPropertyBoolean("Selected", () -> selected, selected -> {
			this.selected = selected;
			return true;
		});
	}

	public Stream<Part> getChildren()
	{
		return Stream.empty();
	}

	@Override
	public void setFactoryAll(GameAlmandine game)
	{
		super.setFactoryAll(game);
		getChildren().forEach(part -> part.setFactoryAll(game));
	}

	public void deleteLater()
	{
		game.factory.deleteLater(this);
	}

}
