package mirrg.simulation.cart.almandine.factory;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;

import com.thoughtworks.xstream.annotations.XStreamOmitField;

public abstract class Entity
{

	@Deprecated
	public Entity()
	{

	}

	public Entity(GameAlmandine game)
	{
		this.game = game;
		this.id = game.factory.freeId();
	}

	@XStreamOmitField
	protected GameAlmandine game;

	/**
	 * 自身と全ての子エンティティにファクトリインスタンスを登録する。
	 */
	public void setFactoryAll(GameAlmandine game)
	{
		this.game = game;
	}

	private int id;

	public int getId()
	{
		return id;
	}

	public void tick(double deltaSecond) throws IllegalEntityIdException
	{

	}

	// TODO
	public double getDurationVoid() throws IllegalEntityIdException
	{
		return 1;
	}

	public abstract void draw(Graphics2D graphics) throws IllegalEntityIdException;

	public abstract void drawOverlay(Graphics2D graphics) throws IllegalEntityIdException;

	public abstract void drawHover(Graphics2D graphics) throws IllegalEntityIdException;

	public abstract boolean isContained(Rectangle rectangle) throws IllegalEntityIdException;

	public abstract boolean isHover(int x, int y) throws IllegalEntityIdException;

	public boolean isHover(Point point) throws IllegalEntityIdException
	{
		return isHover(point.x, point.y);
	}

	public void openWindowProperty(IFrameGameAlmandine frameGameAlmandine)
	{
		IDialogProperty dialogProperty = frameGameAlmandine.createDialogProperty(getClass().getSimpleName()).orElse(null);
		if (dialogProperty == null) return;
		addProperty(dialogProperty);
		frameGameAlmandine.getFrame().hookHidden(e -> dialogProperty.dispose());
		dialogProperty.open();
	}

	protected void addProperty(IDialogProperty dialogProperty)
	{
		dialogProperty.addPropertyInt("Id", "id", () -> id, id -> {

			// 既に存在するIDは棄却
			if (game.factory.getEntity(id).isPresent()) return false;

			game.factory.hookEditPrimaries(() -> {
				this.id = id;
			});

			return true;
		});
	}

	/**
	 * @return エンティティの中心の座標。
	 */
	public abstract Point getPoint() throws IllegalEntityIdException;

}
