package mirrg.simulation.cart.almandine.mods.vanilla.toolcursors;

import java.awt.Color;
import java.awt.Point;

import mirrg.applet.nitrogen.events.NitrogenEventMouse;
import mirrg.applet.nitrogen.events.NitrogenEventMouseMotion;
import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.gui.toolcursor.NitrogenEventToolCursor;
import mirrg.simulation.cart.almandine.gui.toolcursor.ToolCursor;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.Furniture;
import mirrg.swing.helium.logging.HLog;

public class ToolCursorPutFurniture extends ToolCursor
{

	protected ICreatorFurniture creatorFurniture;
	protected String nameFurniture;

	public ToolCursorPutFurniture(IFrameGameAlmandine frameGameAlmandine, ICreatorFurniture creatorFurniture, String nameFurniture)
	{
		super(frameGameAlmandine);
		this.creatorFurniture = creatorFurniture;
		this.nameFurniture = nameFurniture;

		eventManager.register(NitrogenEventMouse.Pressed.class, e -> {
			try {
				getFactory().addLater(creatorFurniture.create(getCoord(e.mouseEvent)));
			} catch (IllegalEntityIdException e2) {
				HLog.processExceptionWarning(e2);
			}
		});
		eventManager.register(NitrogenEventMouseMotion.Moved.class, e -> {
			point = getCoord(e.mouseEvent);
		});
		eventManager.register(NitrogenEventToolCursor.Render.class, e -> {
			if (point == null) return;

			e.graphics.setColor(new Color(0xff0000));

			frameGameAlmandine.doTranslate(e.graphics, () -> {
				e.graphics.drawLine(point.x - 20, point.y - 20, point.x + 20, point.y + 20);
				e.graphics.drawLine(point.x - 20, point.y + 20, point.x + 20, point.y - 20);
			});
		});
	}

	public static interface ICreatorFurniture
	{

		public Furniture create(Point point) throws IllegalEntityIdException;

	}

	@Override
	public String getLocalizedName()
	{
		return "設置：" + nameFurniture;
	}

	private Point point;

	@Override
	public String getLocalizedDescription()
	{
		return "左クリックした地点に設置";
	}

}
