package mirrg.simulation.cart.almandine.mods.vanilla.toolcursors;

import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.stream.Collector;
import java.util.stream.Collectors;

import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.factory.Entity;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.gui.toolcursor.ToolCursor;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.StationBase;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.Cart;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.Cart.PositionRail;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.Cart.PositionStation;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.RailBase;
import mirrg.swing.helium.logging.HLog;

public class ToolCursorPutCart extends ToolCursor
{

	public ToolCursorPutCart(IFrameGameAlmandine frameGameAlmandine)
	{
		super(frameGameAlmandine);

		new ModuleClickEntity<Entity>(frameGameAlmandine, button -> button == MouseEvent.BUTTON1, (e, entity) -> {
			if (entity instanceof StationBase) {

				try {

					getFactory().addLater(new Cart(
						getGame(),
						new PositionStation(entity.getId(), ((StationBase) entity).freeOrder()),
						12,
						5));

				} catch (IllegalEntityIdException e2) {
					HLog.processExceptionWarning(e2);
				}

			} else if (entity instanceof RailBase) {

				try {

					double position = ((RailBase) entity).getPosition(getCoord(e));
					getFactory().addLater(new Cart(
						getGame(),
						new PositionRail(entity.getId(), position, position > 0.5),
						12,
						5));

				} catch (IllegalEntityIdException e1) {
					HLog.processException(e1);
				}

			} else {
				HLog.warning("不正なエンティティが選択されました: " + entity);
			}
		}, (factory, point) -> {
			// 簡潔化するとGradleが怒る
			Collector<Entity, ?, ArrayList<Entity>> collector =
				Collectors.<Entity, ArrayList<Entity>> toCollection(
					() -> new ArrayList<Entity>());
			return Factory.filterHover(factory.getEntities(), point).stream()
				.filter(entity -> entity instanceof StationBase || entity instanceof RailBase)
				.collect(collector);
		}).apply(this);
	}

	@Override
	public String getLocalizedName()
	{
		return "設置：貨車";
	}

	@Override
	public String getLocalizedDescription()
	{
		return "駅またはレールを左クリック";
	}

}
