package mirrg.simulation.cart.almandine.mods.vanilla.toolcursors;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.function.BiFunction;

import mirrg.applet.nitrogen.events.NitrogenEventMouse;
import mirrg.applet.nitrogen.events.NitrogenEventMouseMotion;
import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.gui.toolcursor.NitrogenEventToolCursor;
import mirrg.simulation.cart.almandine.gui.toolcursor.ToolCursor;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.Bound;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.AreaBase;

public class ToolCursorPutArea extends ToolCursor
{

	public ToolCursorPutArea(IFrameGameAlmandine frameGameAlmandine, BiFunction<GameAlmandine, Bound, AreaBase> creator)
	{
		super(frameGameAlmandine);

		eventManager.register(NitrogenEventMouse.Pressed.class, e -> {
			begin = getCoord(e.mouseEvent);
			mouseDragged(e.mouseEvent);
		});
		eventManager.register(NitrogenEventMouse.Released.class, e -> {
			mouseDragged(e.mouseEvent);

			if (begin == null) return;
			if (end == null) return;

			Rectangle area = new Rectangle(
				Math.min(begin.x, end.x),
				Math.min(begin.y, end.y),
				Math.abs(end.x - begin.x),
				Math.abs(end.y - begin.y));

			begin = null;
			end = null;

			//

			getFactory().addLater(creator.apply(getGame(), new Bound(area)));

		});
		eventManager.register(NitrogenEventMouseMotion.Dragged.class, e -> {
			mouseDragged(e.mouseEvent);
		});
		eventManager.register(NitrogenEventToolCursor.Render.class, e -> {
			if (begin == null) return;
			if (end == null) return;

			Rectangle area = new Rectangle(
				Math.min(begin.x, end.x),
				Math.min(begin.y, end.y),
				Math.abs(end.x - begin.x),
				Math.abs(end.y - begin.y));

			frameGameAlmandine.doTranslate(e.graphics, () -> {
				e.graphics.setColor(new Color(0x405ec163, true));
				e.graphics.fill(area);
				e.graphics.setColor(new Color(0xd05ec163, true));
				e.graphics.draw(area);
			});
		});
	}

	private Point begin;
	private Point end;

	public void mouseDragged(MouseEvent e)
	{
		end = getCoord(e);
	}

	@Override
	public String getLocalizedName()
	{
		return "設置：領域";
	}

	@Override
	public String getLocalizedDescription()
	{
		return "左ドラッグで配置";
	}

}
