package mirrg.simulation.cart.almandine.mods.vanilla.toolcursors;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.IntPredicate;

import mirrg.applet.nitrogen.events.NitrogenEventMouse;
import mirrg.applet.nitrogen.events.NitrogenEventMouseMotion;
import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.factory.Entity;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.gui.toolcursor.NitrogenEventToolCursor;
import mirrg.simulation.cart.almandine.gui.toolcursor.ToolCursor;

public class ModuleClickEntity<E extends Entity>
{

	protected IFrameGameAlmandine frameGameAlmandine;
	protected IntPredicate predicateButton;
	protected BiConsumer<MouseEvent, E> listener;
	protected IGetEntities<E> getEntities;

	/**
	 * null: 何もホバーしていない
	 */
	protected E entity;

	/**
	 * @param frameGameAlmandine
	 * @param predicateButton
	 *            そのボタン（左右中央）に反応するかどうか
	 * @param listener
	 * @param getEntities
	 */
	public ModuleClickEntity(
		IFrameGameAlmandine frameGameAlmandine,
		IntPredicate predicateButton,
		BiConsumer<MouseEvent, E> listener,
		IGetEntities<E> getEntities)
	{
		this.frameGameAlmandine = frameGameAlmandine;
		this.predicateButton = predicateButton;
		this.listener = listener;
		this.getEntities = getEntities;
	}

	public static interface IGetEntities<E>
	{

		public ArrayList<? extends E> apply(Factory factory, Point point);

	}

	public void apply(ToolCursor toolCursor)
	{
		toolCursor.eventManager.register(NitrogenEventMouse.Pressed.class, e -> {
			update(e.mouseEvent);

			if (predicateButton.test(e.mouseEvent.getButton())) {

				// ホバー中ならイベント発火
			if (entity != null) {
				listener.accept(e.mouseEvent, entity);
				entity = null;
			}

		}

	}	);
		toolCursor.eventManager.register(NitrogenEventMouseMotion.Moved.class, e -> {
			update(e.mouseEvent);
		});
		toolCursor.eventManager.register(NitrogenEventToolCursor.Render.class, e -> {

			// ホバー中なら光らせる
			if (entity != null) {
				frameGameAlmandine.doTranslate(e.graphics, () -> {

					try {
						entity.drawHover(e.graphics);
					} catch (IllegalEntityIdException e2) {

					}

				});
			}

		});
	}

	private Factory getFactory()
	{
		return frameGameAlmandine.getGame().factory;
	}

	public void update(MouseEvent e)
	{
		entity = getEntities.apply(getFactory(),
			new Point(
				frameGameAlmandine.getXCoord(e.getX()),
				frameGameAlmandine.getYCoord(e.getY()))).stream()
			.findFirst()
			.orElse(null);
	}
}
