package mirrg.simulation.cart.almandine.mods.vanilla.primaries;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;

import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.StationBase;

public abstract class RailBase extends PrimaryConnection<StationBase>
{

	@Deprecated
	public RailBase()
	{
		super();
	}

	public RailBase(GameAlmandine game, StationBase begin, StationBase end)
	{
		super(game, begin, end);
	}

	@Override
	protected Class<StationBase> getClassEntity()
	{
		return StationBase.class;
	}

	@Override
	public void drawBody(Graphics2D graphics) throws IllegalEntityIdException
	{

		Point pointBegin = getEntity(idBegin).getPoint();
		Point pointEnd = getEntity(idEnd).getPoint();

		// 主線
		Stroke stroke = graphics.getStroke();
		graphics.setStroke(new BasicStroke(3));
		{
			graphics.setColor(new Color(getColor()));
			drawMargined(graphics, pointBegin, pointEnd, 0, 1);
		}
		graphics.setStroke(stroke);

	}

	protected abstract int getColor();

	@Override
	protected double getMarginBegin() throws IllegalEntityIdException
	{
		StationBase begin = getEntity(idBegin);
		return begin.radius + 2;
	}

	@Override
	protected double getMarginEnd() throws IllegalEntityIdException
	{
		StationBase end = getEntity(idEnd);
		return end.radius + 2;
	}

	public abstract double getDistance() throws IllegalEntityIdException;

}
