package mirrg.simulation.cart.almandine.mods.vanilla.primaries;

import java.awt.Graphics2D;
import java.util.function.Consumer;
import java.util.stream.Stream;

import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.factory.Entity;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.factory.Part;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.Bound;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.Gauge;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.SlotBase;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.StationBase;

public abstract class Furniture extends PrimaryRectangleBase
{

	@Deprecated
	public Furniture()
	{
		super();
	}

	public Furniture(GameAlmandine game, Bound bound)
	{
		super(game, bound);
	}

	@Override
	public void move(int dx, int dy)
	{
		super.move(dx, dy);

		getSlots().forEach(slot -> slot.move(dx, dy));
		getGauges().forEach(gauge -> gauge.move(dx, dy));
		getStations().forEach(station -> station.move(dx, dy));
	}

	@Override
	public void tick(double deltaSecond) throws IllegalEntityIdException
	{
		Consumer<Entity> consumer = entity -> {
			try {
				entity.tick(deltaSecond);
			} catch (IllegalEntityIdException e) {

			}
		};

		getSlots().forEach(consumer);
		getGauges().forEach(consumer);
		getStations().forEach(consumer);
	}

	@Override
	public void draw(Graphics2D graphics) throws IllegalEntityIdException
	{
		super.draw(graphics);

		getSlots().forEach(entity -> draw(entity, graphics));
		getGauges().forEach(entity -> draw(entity, graphics));
		getStations().forEach(entity -> draw(entity, graphics));
	}

	private void draw(Entity entity, Graphics2D graphics)
	{
		try {
			entity.draw(graphics);
		} catch (IllegalEntityIdException e) {

		}
	}

	protected Stream<SlotBase> getSlots()
	{
		return Stream.empty();
	}

	protected Stream<Gauge> getGauges()
	{
		return Stream.empty();
	}

	protected Stream<StationBase> getStations()
	{
		return Stream.empty();
	}

	@Override
	public Stream<Part> getChildren()
	{
		return Stream.of(getSlots(), getGauges(), getStations())
			.flatMap(stream -> stream);
	}

}
