package mirrg.simulation.cart.almandine.mods.vanilla.furnitures;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.stream.Stream;

import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.Bound;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.SlotBase;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.StationBase;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.Furniture;
import mirrg.simulation.cart.almandine.mods.vanilla.slots.SlotCart;

public class FurnitureStation extends Furniture
{

	public SlotCart slot;
	public StationBase station;

	@Deprecated
	public FurnitureStation()
	{
		super();
	}

	public FurnitureStation(GameAlmandine game, Point point, ICreatorStation creatorStation)
	{
		super(game, new Bound(point.x - 10, point.y - 10, 20, 20));
		station = creatorStation.create(game, point, 20);
		slot = new SlotCart(game, new Bound(point.x - 8, point.y - 8, 16, 16), station.getId());
	}

	public static interface ICreatorStation
	{

		public StationBase create(GameAlmandine game, Point point, int radius);

	}

	public Stream<SlotBase> getSlots()
	{
		return Stream.of(slot);
	}

	@Override
	public Stream<StationBase> getStations()
	{
		return Stream.of(station);
	}

	@Override
	protected void drawBody(Graphics2D graphics)
	{
		graphics.setColor(new Color(0x282751));
		graphics.fill(bound.createShape());
		graphics.setColor(new Color(0x000000));
		graphics.draw(bound.grow(1, 1, 0, 0).createShape());
	}

}
