package mirrg.simulation.cart.almandine.mods.vanilla;

import java.util.Optional;

import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.Environment;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.IProviderEnvironment;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.IStackSlab;

public class ProviderEnvironmentThermoModifier implements IProviderEnvironment
{

	public double temperature;
	public boolean isRelativeTemperature;
	public double temperatureSpawn;
	public boolean isRelativeTemperatureSpawn;
	public double durationHeatHalfLife;
	public boolean isRelativeDurationHeatHalfLife;

	public ProviderEnvironmentThermoModifier()
	{
		temperature = 0;
		isRelativeTemperature = true;
		temperatureSpawn = 0;
		isRelativeTemperatureSpawn = true;
		durationHeatHalfLife = 1;
		isRelativeDurationHeatHalfLife = true;
	}

	@Override
	public void getEnvironment(Environment environment)
	{

		// 温度
		{
			double temperature2;
			if (isRelativeTemperature) {
				Optional<Double> optionalTemperature = environment.getDouble("temperature");
				if (optionalTemperature.isPresent()) {
					temperature2 = optionalTemperature.get();
				} else {
					temperature2 = 0;
				}
				temperature2 += temperature;
			} else {
				temperature2 = temperature;
			}
			environment.doubles.put("temperature", temperature2);
		}

		// スポーン温度
		{
			double old;
			if (isRelativeTemperatureSpawn) {
				Optional<Double> optional = environment.getDouble("temperatureSpawn");
				if (optional.isPresent()) {
					old = optional.get();
				} else {
					old = 0;
				}
				old += temperatureSpawn;
			} else {
				old = temperatureSpawn;
			}
			environment.doubles.put("temperatureSpawn", old);
		}

		// スポーン温度
		{
			double old;
			if (isRelativeDurationHeatHalfLife) {
				Optional<Double> optional = environment.getDouble("durationHeatHalfLife");
				if (optional.isPresent()) {
					old = optional.get();
				} else {
					old = 0;
				}
				old *= durationHeatHalfLife;
			} else {
				old = durationHeatHalfLife;
			}
			environment.doubles.put("durationHeatHalfLife", old);
		}

	}

	public void addProperty(IDialogProperty dialogProperty)
	{
		dialogProperty.addPropertyDouble("Temperature", "℃", () -> temperature, temperature -> {
			this.temperature = temperature;
			return true;
		});
		dialogProperty.addPropertyBoolean("IsRelativeTemperature", () -> isRelativeTemperature, isRelative -> {
			this.isRelativeTemperature = isRelative;
			return true;
		});
		dialogProperty.addPropertyDouble("TemperatureSpawn", "℃", () -> temperatureSpawn, temperatureSpawn -> {
			this.temperatureSpawn = temperatureSpawn;
			return true;
		});
		dialogProperty.addPropertyBoolean("IsRelativeTemperatureSpawn", () -> isRelativeTemperatureSpawn, isRelativeTemperatureSpawn -> {
			this.isRelativeTemperatureSpawn = isRelativeTemperatureSpawn;
			return true;
		});
		dialogProperty.addPropertyDouble("DurationHeatHalfLife 熱差分半減期", "sec or 倍率", () -> durationHeatHalfLife, durationHeatHalfLife -> {
			this.durationHeatHalfLife = durationHeatHalfLife;
			return true;
		});
		dialogProperty.addPropertyBoolean("IsRelativeDurationHeatHalfLife", () -> isRelativeDurationHeatHalfLife, isRelativeDurationHeatHalfLife -> {
			this.isRelativeDurationHeatHalfLife = isRelativeDurationHeatHalfLife;
			return true;
		});
	}

	@Override
	public IStackSlab createStackSlab(int amount, Environment environment)
	{
		return null;
	}

}
