/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.gui.toolcursors;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import mirrg.simulation.cart.almandine.factory.HFactory;
import mirrg.simulation.cart.almandine.gui.FrameMain;
import mirrg.simulation.cart.almandine.gui.ToolCursor;

public class ToolCursorScreen
extends ToolCursor {
    private Point beginLeft;
    private Point beginRight;
    private Point endLeft;
    private Point endRight;

    public ToolCursorScreen(FrameMain frameMain) {
        super(frameMain);
    }

    public String toString() {
        return "\u753b\u9762";
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.beginLeft = new Point(e.getX(), e.getY());
            this.endLeft = new Point(e.getX(), e.getY());
        } else if (e.getButton() == 3) {
            this.beginRight = new Point(e.getX(), e.getY());
            this.endRight = new Point(e.getX(), e.getY());
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.beginLeft != null) {
            Point now = new Point(e.getX(), e.getY());
            this.frameMain.getFactory().offsetX += now.x - this.endLeft.x;
            this.frameMain.getFactory().offsetY += now.y - this.endLeft.y;
            this.endLeft = new Point(e.getX(), e.getY());
        }
        if (this.beginRight != null) {
            this.endRight = new Point(e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            this.beginLeft = null;
            this.endLeft = null;
        } else if (e.getButton() == 3) {
            this.beginRight = null;
            this.endRight = null;
        }
    }

    @Override
    public void render(Graphics2D graphics) {
        if (this.beginLeft != null) {
            graphics.setColor(Color.red);
            graphics.drawLine(this.beginLeft.x, this.beginLeft.y, this.endLeft.x, this.endLeft.y);
        }
        if (this.beginRight != null) {
            graphics.setColor(Color.red);
            Stroke stroke = graphics.getStroke();
            graphics.setStroke(new BasicStroke(2.0f));
            graphics.drawOval(this.beginRight.x - 6, this.beginRight.y - 6, 12, 12);
            graphics.setStroke(stroke);
            HFactory.drawLine(graphics, this.beginRight, this.endRight, 7.0, 0.0, 0.0, 1.0);
        }
    }

    @Override
    public void tick() {
        if (this.beginRight != null) {
            SwingUtilities.invokeLater(() -> {
                if (this.beginRight == null) {
                    return;
                }
                if (this.endRight == null) {
                    return;
                }
                this.frameMain.getFactory().offsetX += (int)((double)(this.endRight.x - this.beginRight.x) * 0.1);
                this.frameMain.getFactory().offsetY += (int)((double)(this.endRight.y - this.beginRight.y) * 0.1);
            });
        }
    }
}

