/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.gui;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.gui.FrameTools;
import mirrg.simulation.cart.almandine.gui.PanelAlmandine;
import mirrg.simulation.cart.almandine.gui.ToolCursor;
import mirrg.simulation.cart.almandine.gui.toolcursors.ToolCursorSelect;
import mirrg.simulation.cart.almandine.property.FrameProperties;
import mirrg.simulation.cart.almandine.property.ManagerProperty;
import mirrg.simulation.cart.almandine.property.PropertyInt;
import mirrg.swing.helium.FrameMirrg;
import mirrg.swing.helium.logging.FrameLog;
import mirrg.swing.helium.logging.HLog;
import mirrg.util.HString;

public class FrameMain
extends FrameMirrg {
    private static final FileNameExtensionFilter FILTER = new FileNameExtensionFilter("Almandine\u4fdd\u5b58\u30d5\u30a1\u30a4\u30eb(*.alm)", "alm");
    private ManagerProperty managerProperty = new ManagerProperty();
    private Factory factory = new Factory(25.0);
    private ToolCursor toolCursor = new ToolCursorSelect(this);
    private File file = null;
    private FrameProperties frameProperties = null;
    private FrameTools frameTools = null;
    private PanelAlmandine panel;
    private String suffixTitle = "Almandine Cart Simulator";
    private JFileChooser _fileChooser = null;

    public ManagerProperty getManagerProperty() {
        return this.managerProperty;
    }

    public Factory getFactory() {
        return this.factory;
    }

    public void setToolCursor(ToolCursor toolCursor) {
        this.toolCursor = toolCursor;
    }

    public ToolCursor getToolCursor() {
        return this.toolCursor;
    }

    public FrameMain() {
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu("\u30d5\u30a1\u30a4\u30eb(F)");
        menuBar.add(menu);
        menu.setMnemonic('F');
        final JMenuItem menuItem = new JMenuItem("\u958b\u304f...(O)");
        menu.add(menuItem);
        menuItem.setMnemonic('O');
        menuItem.addActionListener(e -> this.showDialogLoad());
        menuItem = new JMenuItem("\u4e0a\u66f8\u304d\u4fdd\u5b58(S)");
        menu.add(menuItem);
        menuItem.setMnemonic('S');
        menuItem.addActionListener(e -> this.save());
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                menuItem.setEnabled(FrameMain.this.file != null);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        menuItem = new JMenuItem("\u540d\u524d\u3092\u4ed8\u3051\u3066\u4fdd\u5b58...(A)");
        menu.add(menuItem);
        menuItem.setMnemonic('A');
        menuItem.addActionListener(e -> this.showDialogSave());
        menu = new JMenu("\u30a6\u30a3\u30f3\u30c9\u30a6(W)");
        menuBar.add(menu);
        menu.setMnemonic('W');
        menuItem = new JMenuItem("\u30c4\u30fc\u30eb...(T)");
        menu.add(menuItem);
        menuItem.setMnemonic('T');
        menuItem.addActionListener(e -> {
            if (this.frameTools == null) {
                this.frameTools = new FrameTools(this);
            }
            this.frameTools.setVisible(true);
        });
        this.hookDisposed(e -> {
            if (this.frameTools != null) {
                this.frameTools.dispose();
            }
        });
        menuItem = new JMenuItem("\u30d7\u30ed\u30d1\u30c6\u30a3\u30de\u30cd\u30fc\u30b8\u30e3...(P)");
        menu.add(menuItem);
        menuItem.setMnemonic('P');
        menuItem.addActionListener(e -> {
            if (this.frameProperties == null) {
                this.frameProperties = new FrameProperties(this.managerProperty);
            }
            this.frameProperties.setVisible(true);
        });
        this.hookDisposed(e -> {
            if (this.frameProperties != null) {
                this.frameProperties.dispose();
            }
        });
        menuItem = new JMenuItem("\u30ed\u30b0\u30a6\u30a3\u30f3\u30c9\u30a6...(L)");
        menu.add(menuItem);
        menuItem.setMnemonic('L');
        menuItem.addActionListener(e -> {
            FrameLog frame = new FrameLog(200);
            this.hookDisposed(e2 -> frame.dispose());
            frame.setVisible(true);
        });
        this.panel = new PanelAlmandine(this);
        this.add((Component)((Object)this.panel));
        this.hookInitialized(e -> this.panel.init());
        this.hookShown(e -> this.panel.start());
        this.hookHidden(e -> this.panel.stop());
        this.hookDisposed(e -> this.panel.destroy());
        this.setLayout(new CardLayout());
        URL url = ((Object)((Object)this)).getClass().getResource("icon.png");
        if (url != null) {
            this.setIconImage(new ImageIcon(url).getImage());
        } else {
            HLog.warning((String)"\u30a2\u30a4\u30b3\u30f3\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        }
        this.updateTitle();
        this.prepareFrame();
    }

    public void updateTitle() {
        StringBuilder sb = new StringBuilder();
        if (this.file != null) {
            sb.append(HString.deleteExtension(this.file.getName()));
        }
        if (sb.length() != 0) {
            sb.append(" - ");
        }
        sb.append(this.suffixTitle);
        this.setTitle(sb.toString());
    }

    private JFileChooser getFileChooser() {
        if (this._fileChooser == null) {
            this._fileChooser = new JFileChooser();
            this._fileChooser.addChoosableFileFilter(FILTER);
            this._fileChooser.setAcceptAllFileFilterUsed(true);
            this._fileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        }
        return this._fileChooser;
    }

    private void showDialogLoad() {
        Object data;
        JFileChooser fileChooser = this.getFileChooser();
        int res = fileChooser.showOpenDialog((Component)((Object)this));
        if (res == 1) {
            HLog.info((String)"\u30c0\u30a4\u30a2\u30ed\u30b0\u304c\u30ad\u30e3\u30f3\u30bb\u30eb\u3055\u308c\u307e\u3057\u305f\u3002");
            return;
        }
        if (res == -1) {
            HLog.error((String)("\u30c0\u30a4\u30a2\u30ed\u30b0\u4e0a\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff01: " + res));
            return;
        }
        File file = fileChooser.getSelectedFile();
        if (file.exists()) {
            try {
                data = new XStream().fromXML((InputStream)new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                HLog.processExceptionUnexpected((Exception)e);
                return;
            }
            catch (ConversionException e) {
                HLog.processException((Exception)((Object)e), (String)("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u3066\u304a\u308a\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3067\u3057\u305f\uff01: " + file.getPath()), (boolean)true);
                return;
            }
        } else {
            HLog.error((String)("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\uff01: " + file.getPath()));
            return;
        }
        if (!(data instanceof Factory)) {
            HLog.error((String)("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u307e\u3059\uff01: " + file.getPath()));
            return;
        }
        this.factory = (Factory)data;
        HLog.fine((String)("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u3092\u6b63\u5e38\u306b\u8aad\u307f\u8fbc\u307f\u307e\u3057\u305f\u3002: " + file.getPath()));
        this.file = file;
        this.updateTitle();
        ((PropertyInt)this.getManagerProperty().getProperty((String)"panel.tickPerFrame")).value = 0;
    }

    private void showDialogSave() {
        JFileChooser fileChooser = this.getFileChooser();
        int res = fileChooser.showSaveDialog((Component)((Object)this));
        if (res == 1) {
            HLog.info((String)"\u30c0\u30a4\u30a2\u30ed\u30b0\u304c\u30ad\u30e3\u30f3\u30bb\u30eb\u3055\u308c\u307e\u3057\u305f\u3002");
            return;
        }
        if (res == -1) {
            HLog.error((String)("\u30c0\u30a4\u30a2\u30ed\u30b0\u4e0a\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff01: " + res));
            return;
        }
        File file = fileChooser.getSelectedFile();
        if (fileChooser.getFileFilter() == FILTER) {
            String path = file.getAbsolutePath();
            if (path.equals(HString.deleteExtension(path))) {
                path = path + ".alm";
            }
            file = new File(path);
        }
        this.file = file;
        this.updateTitle();
        this.save();
    }

    private void save() {
        if (this.file.exists()) {
            Path pathBackup = new File(this.file.getAbsolutePath() + ".orig").toPath();
            try {
                Files.copy(this.file.toPath(), pathBackup, StandardCopyOption.REPLACE_EXISTING);
                HLog.fine((String)("\u53e4\u3044\u8a2d\u5b9a\u30c7\u30fc\u30bf\u3092\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u3057\u307e\u3057\u305f: " + pathBackup));
            }
            catch (IOException e) {
                HLog.processException((Exception)e, (String)("\u53e4\u3044\u8a2d\u5b9a\u30c7\u30fc\u30bf\u306e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + pathBackup), (boolean)false);
            }
        }
        try {
            XStream xStream = new XStream();
            xStream.autodetectAnnotations(true);
            xStream.toXML((Object)this.factory, (OutputStream)new FileOutputStream(this.file));
        }
        catch (FileNotFoundException e2) {
            HLog.processException((Exception)e2);
            return;
        }
        HLog.fine((String)("\u8a2d\u5b9a\u30c7\u30fc\u30bf\u3092\u4fdd\u5b58\u3057\u307e\u3057\u305f: " + this.file.getPath()));
    }

    public int getXCoord(MouseEvent e) {
        return e.getX() - this.factory.offsetX - this.panel.getWidth() / 2;
    }

    public int getYCoord(MouseEvent e) {
        return e.getY() - this.factory.offsetY - this.panel.getHeight() / 2;
    }

    public void pushTanslate(Graphics2D graphics) {
        graphics.translate(this.panel.getWidth() / 2, this.panel.getHeight() / 2);
        graphics.translate(this.factory.offsetX, this.factory.offsetY);
    }

    public void popTanslate(Graphics2D graphics) {
        graphics.translate(-this.factory.offsetX, -this.factory.offsetY);
        graphics.translate(-this.panel.getWidth() / 2, -this.panel.getHeight() / 2);
    }
}

