/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.factory.stackslab;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.stackslab.IEnvironmentStackSlab;
import mirrg.simulation.cart.almandine.factory.stackslab.IStackSlab;
import mirrg.simulation.cart.almandine.factory.stackslab.IStackSlabTemperatureSingle;
import mirrg.simulation.cart.almandine.gui.property.IDialogProperty;

public class StackSlabTemperatureSingle
implements IStackSlab,
IStackSlabTemperatureSingle {
    public int amount;
    public double temperature = 0.0;

    @Deprecated
    public StackSlabTemperatureSingle() {
    }

    public StackSlabTemperatureSingle(int amount, String source) {
        this.amount = amount;
        this.temperature = 1000.0;
    }

    public StackSlabTemperatureSingle(int amount, double temperature) {
        this.amount = amount;
        this.temperature = temperature;
    }

    @Override
    public IStackSlab tryPop(int amount) {
        if (this.amount < amount) {
            this.amount = 0;
            return new StackSlabTemperatureSingle(this.amount, this.temperature);
        }
        this.amount -= amount;
        return new StackSlabTemperatureSingle(amount, this.temperature);
    }

    @Override
    public void push(IStackSlab stack) {
        double temperature = stack instanceof IStackSlabTemperatureSingle ? ((IStackSlabTemperatureSingle)((Object)stack)).getTemperatureMean() : 0.0;
        double at = (double)this.amount * this.temperature + (double)stack.getAmount() * temperature;
        this.amount += stack.getAmount();
        if (this.amount != 0) {
            this.temperature = at / (double)this.amount;
        }
        stack.clear();
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public void clear() {
        this.amount = 0;
        this.temperature = 0.0;
    }

    @Override
    public void addProperty(Factory factory, IDialogProperty dialogProperty) {
        dialogProperty.addPropertyInt("Amount", "\u500b", () -> this.amount, amount -> {
            if (amount <= 0) {
                return false;
            }
            this.amount = amount;
            return true;
        });
        dialogProperty.addPropertyDouble("Temperature", "C", () -> this.temperature, temperature -> {
            this.temperature = temperature;
            return true;
        });
    }

    @Override
    public void render(Graphics2D graphics, Rectangle bound, int capacity) {
        graphics.setColor(new Color(128));
        graphics.fill(bound);
        bound = new Rectangle(bound);
        bound.grow(-2, -2);
        graphics.setColor(new Color(0xC0C0C0));
        graphics.fill(bound);
        double r = this.temperature / 1000.0;
        if (r < 0.0) {
            r = 0.0;
        }
        if (r > 1.0) {
            r = 1.0;
        }
        graphics.setColor(new Color((float)r, 0.0f, 0.0f));
        int h = (int)(bound.getHeight() * (double)this.amount / (double)capacity);
        graphics.fillRect((int)bound.getMinX(), (int)bound.getMaxY() - h, (int)bound.getWidth(), h);
    }

    @Override
    public double getTemperatureMean() {
        return this.temperature;
    }

    @Override
    public void tick(Factory factory, double deltaSecond, IEnvironmentStackSlab environment) {
        double gap = this.temperature - factory.temperature;
        double durationHeatHalfLife = environment.getDurationHeatHalfLife();
        if (durationHeatHalfLife == 0.0) {
            this.temperature = gap;
        } else {
            double ratio = Math.pow(0.5, deltaSecond / durationHeatHalfLife);
            this.temperature = factory.temperature + (gap *= ratio);
        }
    }
}

