/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.factory.primaries;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import mirrg.simulation.cart.almandine.factory.Entity;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.FrameProperty;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.factory.parts.Station;
import mirrg.simulation.cart.almandine.factory.primaries.PrimaryConnection;

public class Rail
extends PrimaryConnection<Station> {
    public double distance;

    @Deprecated
    public Rail() {
    }

    public Rail(Factory factory, Station begin, Station end, double distance) {
        super(factory, begin, end);
        this.distance = distance;
    }

    @Override
    protected Station castEntity(Entity entity) {
        if (entity instanceof Station) {
            return (Station)entity;
        }
        return null;
    }

    @Override
    public void renderBody(Factory factory, Graphics2D graphics) throws IllegalEntityIdException {
        Station begin = (Station)this.getEntity(factory, this.idBegin);
        Point pointBegin = begin.getPoint(factory);
        Station end = (Station)this.getEntity(factory, this.idEnd);
        Point pointEnd = end.getPoint(factory);
        Stroke stroke = graphics.getStroke();
        graphics.setStroke(new BasicStroke(3.0f));
        graphics.setColor(new Color(2449));
        this.drawMargined(graphics, factory, pointBegin, pointEnd, 0.0, 1.0);
        graphics.setStroke(stroke);
    }

    @Override
    protected void addProperty(Factory factory, FrameProperty frameProperty) {
        super.addProperty(factory, frameProperty);
        frameProperty.addPropertyDouble("Distance", () -> this.distance, distance -> {
            if (distance <= 0.0) {
                return false;
            }
            this.distance = distance;
            return true;
        });
    }

    @Override
    protected double getMarginBegin(Factory factory) throws IllegalEntityIdException {
        Station begin = (Station)this.getEntity(factory, this.idBegin);
        return begin.radius + 2;
    }

    @Override
    protected double getMarginEnd(Factory factory) throws IllegalEntityIdException {
        Station end = (Station)this.getEntity(factory, this.idEnd);
        return end.radius + 2;
    }
}

