/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.factory.primaries;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.Optional;
import mirrg.simulation.cart.almandine.factory.Entity;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.FrameProperty;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.factory.SlotSlab;
import mirrg.simulation.cart.almandine.factory.parts.Station;
import mirrg.simulation.cart.almandine.factory.primaries.Primary;
import mirrg.simulation.cart.almandine.factory.primaries.Rail;

public class Cart
extends Primary {
    public SlotSlab slotSlab;
    public IPosition position;
    public double speed;

    @Deprecated
    public Cart() {
    }

    public Cart(Factory factory, IPosition position, int capacity, double speed) {
        super(factory);
        this.position = position;
        this.slotSlab = new SlotSlab(factory, capacity);
        this.speed = speed;
    }

    @Override
    public void render(Factory factory, Graphics2D graphics) throws IllegalEntityIdException {
        Point point = this.getPoint(factory);
        double angle = this.position.getAngle(factory);
        graphics.translate(point.x, point.y);
        graphics.rotate(angle);
        graphics.setColor(new Color(0x886644));
        graphics.fillRect(-20, -8, 40, 16);
        graphics.setColor(new Color(0x443322));
        graphics.drawRect(-21, -9, 41, 17);
        graphics.rotate(1.5707963267948966);
        this.slotSlab.render(graphics, new Rectangle(-5, -17, 10, 34));
        graphics.rotate(-1.5707963267948966);
        graphics.rotate(-angle);
        graphics.translate(-point.x, -point.y);
    }

    @Override
    public void renderHover(Factory factory, Graphics2D graphics) throws IllegalEntityIdException {
        Point point = this.getPoint(factory);
        int radius = 18;
        Stroke stroke = graphics.getStroke();
        graphics.setStroke(new BasicStroke(2.0f));
        graphics.setColor(new Color(8125570));
        graphics.draw(new Ellipse2D.Double(point.x - radius, point.y - radius, radius * 2, radius * 2));
        graphics.setStroke(stroke);
    }

    @Override
    public boolean isHover(Factory factory, int x, int y) throws IllegalEntityIdException {
        return this.getPoint(factory).distanceSq(x, y) < 196.0;
    }

    @Override
    public void tick(Factory factory, double deltaSecond) throws IllegalEntityIdException {
        if (this.position instanceof PositionRail) {
            PositionRail positionRail = (PositionRail)this.position;
            double deltaX = this.speed * deltaSecond;
            Rail rail = positionRail.getRail(factory);
            double deltaRate = deltaX / rail.distance;
            positionRail.position = positionRail.position + deltaRate * (double)(positionRail.direction ? 1 : -1);
            if (positionRail.position <= 0.0) {
                Station station = (Station)rail.getEntity(factory, rail.idBegin);
                this.position = new PositionStation(station.getId(), station.freeOrder(factory), rail.getId());
            } else if (positionRail.position >= 1.0) {
                Station station = (Station)rail.getEntity(factory, rail.idEnd);
                this.position = new PositionStation(station.getId(), station.freeOrder(factory), rail.getId());
            }
        }
    }

    @Override
    public Point getPoint(Factory factory) throws IllegalEntityIdException {
        Point2D.Double point = this.position.getPoint(factory);
        return new Point((int)point.x, (int)point.y);
    }

    @Override
    protected void addProperty(Factory factory, FrameProperty frameProperty) {
        super.addProperty(factory, frameProperty);
        this.slotSlab.addProperty(factory, frameProperty);
        frameProperty.addPropertyDouble("Speed", () -> this.speed, speed -> {
            if (speed < 0.0) {
                return false;
            }
            this.speed = speed;
            return true;
        });
        frameProperty.addPropertyInt("IdRail (Rail)", () -> {
            if (this.position instanceof PositionRail) {
                return ((PositionRail)this.position).idRail;
            }
            return -1;
        }, idRail -> {
            if (this.position instanceof PositionRail) {
                Entity entity = factory.getEntity(idRail).orElse(null);
                if (entity == null) {
                    return false;
                }
                if (!(entity instanceof Rail)) {
                    return false;
                }
                ((PositionRail)this.position).idRail = idRail;
                return true;
            }
            return false;
        });
        frameProperty.addPropertyDouble("Position (Rail)", () -> {
            if (this.position instanceof PositionRail) {
                return ((PositionRail)this.position).position;
            }
            return -1.0;
        }, position -> {
            if (this.position instanceof PositionRail) {
                if (position < 0.0) {
                    return false;
                }
                if (position > 1.0) {
                    return false;
                }
                ((PositionRail)this.position).position = position;
                return true;
            }
            return false;
        });
        frameProperty.addPropertyBoolean("Direction == POSITIVE (Rail)", () -> {
            if (this.position instanceof PositionRail) {
                return ((PositionRail)this.position).direction;
            }
            return false;
        }, direction -> {
            if (this.position instanceof PositionRail) {
                ((PositionRail)this.position).direction = direction;
                return true;
            }
            return false;
        });
        frameProperty.addPropertyInt("IdStation (Station)", () -> {
            if (this.position instanceof PositionStation) {
                return ((PositionStation)this.position).idStation;
            }
            return -1;
        }, idStation -> {
            if (this.position instanceof PositionStation) {
                Entity entity = factory.getEntity(idStation).orElse(null);
                if (entity == null) {
                    return false;
                }
                if (!(entity instanceof Station)) {
                    return false;
                }
                ((PositionStation)this.position).idStation = idStation;
                return true;
            }
            return false;
        });
        frameProperty.addPropertyInt("Order (Station)", () -> {
            if (this.position instanceof PositionStation) {
                return ((PositionStation)this.position).order;
            }
            return -1;
        }, order -> {
            if (this.position instanceof PositionStation) {
                ((PositionStation)this.position).order = order;
                return true;
            }
            return false;
        });
        frameProperty.addPropertyInt("IdRailFrom (Station)", () -> {
            if (this.position instanceof PositionStation) {
                return ((PositionStation)this.position).idRailFrom;
            }
            return -1;
        }, idRailFrom -> {
            if (this.position instanceof PositionStation) {
                Entity entity = factory.getEntity(idRailFrom).orElse(null);
                if (entity == null) {
                    return false;
                }
                if (!(entity instanceof Rail)) {
                    return false;
                }
                ((PositionStation)this.position).idRailFrom = idRailFrom;
                return true;
            }
            return false;
        });
    }

    public static class PositionRail
    implements IPosition {
        public int idRail;
        public double position;
        public boolean direction;

        public PositionRail() {
        }

        public PositionRail(int idRail, double position, boolean direction) {
            this.idRail = idRail;
            this.position = position;
            this.direction = direction;
        }

        @Override
        public Point2D.Double getPoint(Factory factory) throws IllegalEntityIdException {
            return this.getRail(factory).getPoint(factory, this.position);
        }

        @Override
        public double getAngle(Factory factory) throws IllegalEntityIdException {
            return this.getRail(factory).getAngle(factory);
        }

        public Rail getRail(Factory factory) throws IllegalEntityIdException {
            Entity entity = factory.getEntity(this.idRail).orElse(null);
            if (entity == null) {
                throw new IllegalEntityIdException("id=" + this.idRail);
            }
            if (!(entity instanceof Rail)) {
                throw new IllegalEntityIdException("id=" + this.idRail);
            }
            return (Rail)entity;
        }
    }

    public static class PositionStation
    implements IPosition {
        public int idStation;
        public int order;
        public int idRailFrom;

        public PositionStation() {
        }

        public PositionStation(int idStation, int order) {
            this(idStation, order, -1);
        }

        public PositionStation(int idStation, int order, int idRailFrom) {
            this.idStation = idStation;
            this.order = order;
            this.idRailFrom = idRailFrom;
        }

        @Override
        public Point2D.Double getPoint(Factory factory) throws IllegalEntityIdException {
            Station station = this.getStation(factory);
            Point point = station.getPoint(factory);
            point.translate(0, station.radius + 2);
            point.translate(0, 20 * this.order);
            return new Point2D.Double(point.x, point.y);
        }

        @Override
        public double getAngle(Factory factory) throws IllegalEntityIdException {
            return 0.0;
        }

        public Station getStation(Factory factory) throws IllegalEntityIdException {
            Entity entity = factory.getEntity(this.idStation).orElse(null);
            if (entity == null) {
                throw new IllegalEntityIdException("id=" + this.idStation);
            }
            if (!(entity instanceof Station)) {
                throw new IllegalEntityIdException("id=" + this.idStation);
            }
            return (Station)entity;
        }

        public Optional<Rail> getRailFrom(Factory factory) {
            Entity entity = factory.getEntity(this.idRailFrom).orElse(null);
            if (entity == null) {
                return Optional.empty();
            }
            if (!(entity instanceof Rail)) {
                return Optional.empty();
            }
            return Optional.of((Rail)entity);
        }
    }

    public static interface IPosition {
        public Point2D.Double getPoint(Factory var1) throws IllegalEntityIdException;

        public double getAngle(Factory var1) throws IllegalEntityIdException;
    }
}

