/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.factory;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.stackslab.IStackSlab;
import mirrg.simulation.cart.almandine.gui.property.IDialogProperty;

public class SlotSlab {
    public IStackSlab stack;
    public int capacity;

    public SlotSlab() {
    }

    public SlotSlab(Factory factory, int capacity) {
        this.stack = factory.createStackSlab();
        this.capacity = capacity;
    }

    public IStackSlab tryPop(int amount) {
        return this.stack.tryPop(amount);
    }

    public void render(Graphics2D graphics, Rectangle bound) {
        this.stack.render(graphics, bound, this.capacity);
    }

    public int tryPush(IStackSlab stack) {
        int amount = this.stack.getAmount() + stack.getAmount() > this.capacity ? this.capacity - this.stack.getAmount() : stack.getAmount();
        IStackSlab stackTransfer = stack.tryPop(amount);
        amount = stackTransfer.getAmount();
        this.stack.push(stackTransfer);
        return amount;
    }

    public void addProperty(Factory factory, IDialogProperty dialogProperty) {
        this.stack.addProperty(factory, dialogProperty);
        dialogProperty.addPropertyInt("Capacity", "\u500b", () -> this.capacity, capacity -> {
            if (capacity <= 0) {
                return false;
            }
            this.capacity = capacity;
            return true;
        });
    }

    public boolean isFull() {
        return this.stack.getAmount() >= this.capacity;
    }

    public boolean isEmpty() {
        return this.stack.getAmount() <= 0;
    }
}

