/***************************************************************************/
/** @file       input_keyboard.cpp
    @brief      
    @author     shom
    @internal
----------------------------------------------------------------------------
    $id
****************************************************************************/

#include "pch_core.h"

#include "input_keyboard.h"

#include "raw/input_raw_keyboard.h"


/***************************************************************************
	cinput_keyboard
****************************************************************************/

#ifdef DX
cinput_keyboard::cinput_keyboard( LPDIRECTINPUT8 p_dinput )
#else	//if GL
cinput_keyboard::cinput_keyboard()
#endif
:
m_keystate_cur(0),
m_keystate_req(0)//,
{
#ifdef DX
	m_p_input_raw = new cinput_raw_keyboard( p_dinput );
#else	//elif GL
	m_p_input_raw = new cinput_raw_keyboard();
#endif
}

void	cinput_keyboard::Update()
{
	if( !m_p_input_raw )
	{
		return;
	}
	
	m_keystate_cur = m_keystate_req;
	m_keystate_req =
		RCAST< cinput_raw_keyboard* >( m_p_input_raw )->GetState();
}

u32		cinput_keyboard::GetPush( u32 in_key )	const
{
	return ( ~( m_keystate_cur & in_key ) & GetPushing( in_key ) );
}

u32		cinput_keyboard::GetPull( u32 in_key )	const
{
	return ( ( m_keystate_cur & in_key ) & ~( GetPushing( in_key ) ) );
}

u32		cinput_keyboard::GetPushing( u32 in_key )		const
{
	return ( m_keystate_req & in_key );
}

b32		cinput_keyboard::IsRepeat( u32 in_key, f32 in_tm_repeat )	const
{
	//UNDONE
	UNUSED( in_key );
	UNUSED( in_tm_repeat );
	return FALSE;
}

void	cinput_keyboard::RestartDevice()
{
	if( m_p_input_raw )
	{	
		m_p_input_raw->RestartDevice();
	}
}
