/***************************************************************************/
/** @file       font.h
    @brief      
    @author     shom
    @internal
****************************************************************************/

#pragma once

class cimage_board;


class CFontCharacter_Base
{
public:
	CFontCharacter_Base();

	virtual void	Initialize( const TCHAR* sz_path_texture );
	virtual void	Finalize();

	virtual void	SetContext( const font_def::FontContext_t& in_context );

	virtual void	Draw( u32 in_character, const vec2f& in_v2_pos );

protected:
	virtual void	calc_texture_uv(
		u32 in_character,
		vec2f& out_v2_start, vec2f& out_v2_end
		) = 0;

	SPTR_T( cimage_board )	m_p_iboard_font;
};

class CFontCharacter_Ascii
:
public CFontCharacter_Base
{
public:
	CFontCharacter_Ascii();

	virtual void	Initialize();

protected:
	virtual void	calc_texture_uv(
		u32 in_character,
		vec2f& out_v2_start, vec2f& out_v2_end
		);
};

class CFontCharacter_Sjis
:
public CFontCharacter_Base
{
public:
	CFontCharacter_Sjis();

	virtual void	Initialize();

protected:
	virtual void	calc_texture_uv(
		u32 in_character,
		vec2f& out_v2_start, vec2f& out_v2_end
		);
};


class CFont_Texture_Raw
{
public:
	CFont_Texture_Raw();

	void	Initialize();
	void	Finalize();

	void	Draw( const char* const in_sz_msg, const font_def::FontContext_t& in_context );

private:
	SPTR_T( CFontCharacter_Ascii )	m_p_character_ascii;
	SPTR_T( CFontCharacter_Sjis )	m_p_character_sjis;
};
