<?php

/*
  ┌─────────────────────────────────────────────────┐
  │      *クラス名       : compile
  │       *概要     ：自作のテンプレートエンジンです。
 * 
 * 
 * 
 * 
  │
  │
  │       *作成者        ：shie.plus*2 椎本
  │
  │   ***********＜＜記録＞＞***********
  │     YYYY/MM/DD 新規作成
  │
  │
  └─────────────────────────────────────────────────┘
 */

class compile {

	var $view_str;
	/*
	 * set_paramsで挿入されるユーザー変数。
	 */
	var $base_url = ''; //indexのURLパス。
	var $layout_file = '';
	var $view_ext = ''; //テンプレートファイルの拡張子。
	var $view_file = '';
	var $view_dir = '';
	var $view_file_name = '';
	var $view_file_path = '';
	var $layout_file_name = '';
	var $layout_file_path = '';

	/*
	 * 特殊ファンクション名
	 */
	var $filter = array(
		'p' => 'print'
	);


	/*
	 * 
	 */
	var $php_start = '<?php ';
	var $php_end = ' ?>';

	/*
	 * ▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽
	 * 	No		:	1
	 * 	title	: compile
	 * 	説明		: テンプレートファイルをコンパイルして、返す。
	 * 	@params	:	$file(str) : 使用するファイル名
	 * 	@return	:	$html(str) : $bool=FALSEの場合にhtml文字列を返す。
	 * -----------------------------------------------------------------
	 */

	public function do_compile($file = NULL) {
		if(!is_null($file)){
			$str = $this->__file_to_str($file);
		}else{
			$str = $this->__file_to_str();
		}
		$str = $this->__end_compile($str);
		$str = $this->__body_compile($str);
		$str = $this->__elm_compile($str);
		$str = $this->__if_compile($str);
		$str = $this->__for_compile($str);
		//{関数}と{{関数}}をコンパイル
		$str = $this->__func_compile($str);
		//{hoge}と{{hoge}}をコンパイル
		$str = $this->__hash_compile($str);
		//{# #}をコンパイル
		$str = $this->__coment_compile($str);
		return $str;
	}

	/*
	 * ▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽
	 * 	No		:	2
	 * 	title	: set_param
	 * 	説明		: layoutClassからの情報を保存するクラス。
	 * 	@params	:	$array(array) : せっとする情報が入っている。
	 * 	@return	:	$html(str) : $bool=FALSEの場合にhtml文字列を返す。
	 * -----------------------------------------------------------------
	 */

	public function set_param($array) {
		$this->base_url = $array['base_url'];
		$this->layout_file = $array['layout_file'];
		$this->view_ext = $array['view_ext'];
		$this->view_file = $array['view_file'];
		$this->view_dir = $array['view_dir'];
		$this->view_file_name = $this->view_file . '.' . $this->view_ext;
		$this->view_file_path = "{$this->base_url}{$this->view_dir}/{$this->view_file_name}";
		$this->layout_file_name = $this->layout_file . '.' . $this->view_ext;
		$this->layout_file_path = "{$this->base_url}{$this->view_dir}/{$this->layout_file_name}";
	}

	/*
	 *　データ取得系の関数。
	  ▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽
	  ▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽
	 */
	/*
	 * {{elm('file_name')}}をコンパイルする。
	 */
	private function __elm_compile($str){
		$need = '/{{[\s\t]*elm\((\w*)\)[\s\t]*}}/';
		$str = preg_replace_callback($need, array($this,'__ret_elm_str'), $str);
		return $str;
	}
	private function __ret_elm_str($macth){
		$str = $this->do_compile($macth[1]);
		return $str;
	}
	/*
	 * {body()}をコンパイルする。
	 * テンプレートファイルの中の{{body()}}をviewファイルの中身に入れ替える。
	 */
	private function __body_compile($str){
		$need = '/{{[\s\t]*body\(.*\)[\s\t]*}}/';
		$str = preg_replace_callback($need, array($this,'__ret_body_str'), $str);
		return $str;
	}
	private function __ret_body_str($macth){
		$str = $this->do_compile($this->view_file);
		return $str;
	}
	/*
	 *　コメントをコンパイル。
	  ▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽
	  ▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽
	 */
	/*
	 *  {# #}をコンパイルする。
	 */
	private function __coment_compile($str){
		$need = '/{#(.*)*}/';
		$pat = '<?php /* $1 */?>';
		$str = preg_replace($need, $pat , $str);
		return $str;
	}
	/*
	 * 関数をコンパイルする。
	  ▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽
	  ▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽
	 */
	
	
	/*
	 * {関数}と{{関数}}をコンパイル
	 */

	private function __func_compile($temp_str) {
		/* {{func(hoge)}}<?php func(hoge); ?>にする。 */
		$need = '/{{[\s\t]*\w+[\(].+[\)][\s\t]*}}/';
		$temp_str = preg_replace_callback($need, array($this, '__ret_php_func'), $temp_str);
		//{hoge}を$hogeにする。
		$need = '/{[\s\t]*\w+[\(].+[\)][\s\t]*}/';
		$temp_str = preg_replace_callback($need, array($this, '__ret_plain_func'), $temp_str);
		return $temp_str;
	}

	/*
	 * {{func(hoge)}}<?php func(hoge); ?>にするコールバック関数
	 */

	private function __ret_php_func($macth) {
		$str = $macth[0];
		$need = array('/^{{[\s\t]*/', '/[\s\t]*}}$/');
		$str = preg_replace($need, '', $str);
		$str = $this->php_start . $this->__make_func_str($str) . $this->php_end;
		return $str;
	}

	/*
	 * {func(hoge)}を func(hoge) にするコールバック関数
	 */

	private function __ret_plain_func($macth) {
		$str = $macth[0];
		$need = array('/^{[\s\t]*/', '/[\s\t]*}$/');
		$str = preg_replace($need, '', $str);
		$str = $this->__make_func_str($str, FALSE);
		return $str;
	}

	/*
	 * func(hoge)をfunc(hoge);にする
	 */

	private function __make_func_str($str, $end = TRUE) {
		//$end = TRUE=>最後に「;」を付ける。FALSE＝＞付けない
		$ret = '';
		$kanma = (strpos($str, ',') === FALSE) ? mb_strlen($str) : strpos($str, ',');
		$cakko = (strpos($str, '(') === FALSE) ? mb_strlen($str) : strpos($str, '(');
		if ($kanma === mb_strlen($str) && $cakko === mb_strlen($str)) {
			$ret .= $this->__make_hash_str($str);
		} elseif ($kanma < $cakko) {
			$ret .=$this->__separate(',', $str);
		} else {
			$ret .=$this->__separate('(', $str);
		}
		if ($end === TRUE) {
			$ret .= ';';
		}
		return $ret;
	}

	private function __separate($sep, $str) {
		$ret = '';
		$array = explode($sep, $str, 2);
		if ($sep == ',') {
			$ret .= $this->__make_hash_str($array[0]) . ',';
			$ret .= $this->__make_func_str($array[1], FALSE);
		} else {
			$ret .= $this->__make_func_name($array[0]);
			$ret .= $this->__make_func_str($array[1], FALSE);
		}
		return $ret;
	}

	private function __make_func_name($str) {
		$need = array(
			'/^p$/' => 'print('
		);
		$key = array_keys($need);
		$val = array_values($need);
		return preg_replace($key, $val, $str);
	}

	/*
	 * {hoge}と{{}}をコンパイル
	 */

	/* ▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽ */

	private function __hash_compile($temp_str) {
		/* {{hoge}}を<?php $hoge; ?>にする。 */
		$need = '/{{[\s\t]*(.+)[\s\t]*}}/';
		$temp_str = preg_replace_callback($need, array($this, '__ret_php_hash'), $temp_str);
		//{hoge}を$hogeにする。
		$need = '/{[\s\t]*(.+)[\s\t]*}/';
		$temp_str = preg_replace_callback($need, array($this, '__ret_plain_hash'), $temp_str);
		return $temp_str;
	}

	/*
	 * 	/*{{hoge}}を<?php $hoge; ?>にする
	 */

	private function __ret_php_hash($str) {
		return $this->php_start . $this->__make_hash_str($str[1]) . $this->php_end;
	}

	/*
	 * {hoge}を形に
	 */

	private function __ret_plain_hash($str) {
		return $this->__make_hash_str($str[1], FALSE);
	}

	private function __make_hash_str($str, $end = FALSE) {
		$array = explode('.', $str);
		$hash = '';
		foreach ($array as $key => $val) {
			if ($key === 0) {
				if (preg_match('/^(\'|\"|<|\$)\w+(\'|\"|>)$/', $val)) {
					$hash .= preg_replace(array('/^</', '/>$/'), '', $val);
				} else {
					if (preg_match('/^\w+[\)]*$/', $val)) {
						$hash .= '$' . $val;
					} else {
						$hash .= $val;
					}
				}
			} else {
				if(preg_match('/^\w+[\)]$/',$val)){
					$val =  str_replace(')','',$val);
					$hash .= '[\'' . $val . '\'])';
				}else{
					$hash .= '[\'' . $val . '\']';
				}

			}
		}
		if ($end === TRUE) {
			$hash .= ';';
		}
		return $hash;
	}
	
	
	/*
	 * 予定関数を
	 ▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽
	 ▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽
	 */

	/*
	 * forをコンパイル
	 */

	private function __for_compile($temp_str) {
		$need = array(
			'/{{[\s\t]*foreach[\s\t]+(.+)[\s\t]+}}/' => '<?php foreach ($1) ?>'
		);
		return preg_replace(array_keys($need), array_values($need), $temp_str);
	}

	/*
	 * 　ifを形に。 
	 */

	private function __if_compile($temp_str) {
		$need = array(
			'/{{[\s\t]*if[\s\t]+(.+)[\s\t]+}}/' => '<?php if ($1) ?>'
		);
		return preg_replace(array_keys($need), array_values($need), $temp_str);
	}
	
	/*
	 * {{ / }}をコンパイル
	 */
	private function __end_compile($str){
		return preg_replace('/{{[\s\t]*}[\s\t]*}}/', '<?php } ?>', $str);
	}

	/*
	 * ファイル関係の関数
	  ▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽
	  ▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽
	 */

	/**
	 * 各情報の整理
	 * @param : $file(str):特定のファイルをコンパイルしたいときに使用する。
	 */
	private function __file_to_str($file = NULL) {
		if (!is_null($file)) {
			$file_name = $file . '.' . $this->view_ext;
			$file_path = "{$this->base_url}{$this->view_dir}/{$file_name}";
			$str = file_get_contents($file_path);
		} elseif ($this->layout_file == '') {
			$str  = file_get_contents($this->view_file_path);
		} else {
			$str  = file_get_contents($this->layout_file_path);
		}
		return $str;
	}

}

?>
