/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.example.hello.android.web_server_jetty_service_hello;

import android.app.Service;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.os.IBinder;
import android.util.Log;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.bio.SocketConnector;

/**
 *
 * @author sawai
 */
public class JettyService extends Service
{

	public static final String SERVER_URI_KEY = "server_uri";
	public static final String SERVER_HOST = "localhost";
	private static final String LOG_TAG = "JettyService";
	private boolean running;
	private HelloJettyHandler helloHandler = new HelloJettyHandler();
	private Server jettyServer;
	private SharedPreferences prefs;

	@Override
	public void onCreate()
	{
		Log.v(LOG_TAG, "onCreate()");
		super.onCreate();
		prefs = getSharedPreferences(getPackageName(), MODE_PRIVATE);
		running = false;
	}

	@Override
	public void onDestroy()
	{
		Log.v(LOG_TAG, "onDestroy()");
		stopJettyServer();
		running = false;
		super.onDestroy();
	}

	@Override
	public void onStart(Intent intent, int startId)
	{
		Log.v(LOG_TAG, "onStart()");
		super.onStart(intent, startId);
		if (!running)
		{
			running = true;
			startJettyServer();
		}
	}

	@Override
	public IBinder onBind(Intent arg0)
	{
		Log.v(LOG_TAG, "onBind()");
		return null;
	}

	private void startJettyServer()
	{
		Log.v(LOG_TAG, "startJettyServer() : Hello");
		try
		{
			SocketConnector socketConnector = new SocketConnector();
			socketConnector.setHost(SERVER_HOST);
			Server server = new Server();

			server.setHandler(helloHandler);
			server.addConnector(socketConnector);
			server.start();

			String name = socketConnector.getName();
			String host = socketConnector.getHost();
			int port = socketConnector.getPort();

			Log.v(LOG_TAG, "startJettyServer() : name => " + name);
			Log.v(LOG_TAG, "startJettyServer() : host => " + host);
			Log.v(LOG_TAG, "startJettyServer() : port => " + port);
			Log.v(LOG_TAG, "startJettyServer() : confidentialScheme => " + socketConnector.getConfidentialScheme());
			Log.v(LOG_TAG, "startJettyServer() : confidentialPort => " + socketConnector.getConfidentialPort());
			Log.v(LOG_TAG, "startJettyServer() : integralScheme => " + socketConnector.getIntegralScheme());
			Log.v(LOG_TAG, "startJettyServer() : integralPort => " + socketConnector.getIntegralPort());
			Log.v(LOG_TAG, "startJettyServer() : localPort => " + socketConnector.getLocalPort());
			String uri = "http://" + name;

			Editor edit = prefs.edit();
			edit.putString(SERVER_URI_KEY, uri);
			edit.commit();

			jettyServer = server;
		}
		catch (Exception ex)
		{
			Log.e(LOG_TAG, "Start Jetty Server : failed.", ex);
		}
		Log.v(LOG_TAG, "startJettyServer() : Bye");
	}

	private void stopJettyServer()
	{
		Log.v(LOG_TAG, "stopJettyServer() : Hello");

		if (jettyServer != null && jettyServer.isRunning())
		{
			try
			{
				jettyServer.stop();

				Editor edit = prefs.edit();
				edit.remove(SERVER_URI_KEY);
				edit.commit();
			}
			catch (Exception ex)
			{
				Log.e(LOG_TAG, "Stop Jetty Server : failed.", ex);
			}
		}

		Log.v(LOG_TAG, "stopJettyServer() : Bye");
	}
}
