package com.example.hello.android.viewflipper_with_animation;

/**
 * The MIT License
 *
 * Copyright 2013 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.ViewFlipper;

public class MainActivity extends Activity implements OnClickListener
{

	private ViewFlipper viewFlipper;
	private Animation slideInLeftAnimation;
	private Animation slideInRightAnimation;
	private Animation slideOutLeftAnimation;
	private Animation slideOutRightAnimation;

	@Override
	public void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main_activity);
		viewFlipper = (ViewFlipper) findViewById(R.id.viewflipper);

		slideInLeftAnimation = AnimationUtils.loadAnimation(this, R.anim.slide_in_left);
		slideInRightAnimation = AnimationUtils.loadAnimation(this, R.anim.slide_in_right);
		slideOutLeftAnimation = AnimationUtils.loadAnimation(this, R.anim.slide_out_left);
		slideOutRightAnimation = AnimationUtils.loadAnimation(this, R.anim.slide_out_right);

		Button nextButton = (Button) findViewById(R.id.next_button);
		Button prevButton = (Button) findViewById(R.id.prev_button);
		nextButton.setOnClickListener(this);
		prevButton.setOnClickListener(this);
	}

	public void onClick(View v)
	{
		switch (v.getId())
		{
			case R.id.next_button:
				showNextPage();
				break;
			case R.id.prev_button:
				showPreviousPage();
				break;
		}
	}

	private void showNextPage()
	{
		viewFlipper.setInAnimation(slideInRightAnimation);
		viewFlipper.setOutAnimation(slideOutLeftAnimation);
		viewFlipper.showNext();

	}

	private void showPreviousPage()
	{
		viewFlipper.setInAnimation(slideInLeftAnimation);
		viewFlipper.setOutAnimation(slideOutRightAnimation);
		viewFlipper.showPrevious();
	}
}
