package com.example.hello.android.ratingbar_hello;

import android.app.Activity;
import android.os.Bundle;
import android.widget.RatingBar;
import android.widget.TextView;

public class MainActivity extends Activity
	implements RatingBar.OnRatingBarChangeListener
{

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{

		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		RatingBar helloRatingBar = (RatingBar) findViewById(R.id.hello_ratingbar);
		helloRatingBar.setOnRatingBarChangeListener(this);

		updateRatingText(helloRatingBar.getRating());
	}

	private void updateRatingText(float rating)
	{
		TextView ratingTextView = (TextView) findViewById(R.id.rating_textview);
		String ratingText = String.format("%.02f", rating);
		ratingTextView.setText(ratingText);
	}

	public void onRatingChanged(RatingBar ratingBar, float rating, boolean fromUser)
	{
		updateRatingText(rating);
	}
}
