/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.ui_pattern_listview_detail_editor;

import android.app.ListActivity;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.SimpleCursorAdapter;
import com.example.hello.android.ui_pattern_listview_detail_editor.db.UserDBConstants;
import com.example.hello.android.ui_pattern_listview_detail_editor.db.UserDBHelper;

public class UserListActivity extends ListActivity
	implements UserDBConstants, OnItemClickListener
{

	private static final String[] MAPPING_FROM =
	{
		Columns.NAME,
		Columns.EMAIL,
	};
	private static final int[] MAPPING_TO =
	{
		android.R.id.text1,
		android.R.id.text2,
	};
	private static final int REQUEST_USER_DETAIL_EDIT = 0;
	private SQLiteDatabase db;
	private Cursor cursor;
	private SimpleCursorAdapter listAdapter;

	public void onItemClick(AdapterView<?> parent, View view, int position, long id)
	{
		startUserDetailActivity(id);
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu)
	{
		getMenuInflater().inflate(R.menu.user_list_activity_option_menu, menu);
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item)
	{
		boolean result = true;
		switch (item.getItemId())
		{
			case R.id.add_user_menuitem:
				startUserDetailActivity();
				break;
			default:
				result = false;
		}
		return result;
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data)
	{
		if (requestCode == REQUEST_USER_DETAIL_EDIT)
		{
			reload();
		}
	}

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.user_list_activity);

		// Init data
		UserDBHelper userDBHelper = new UserDBHelper(this);
		db = userDBHelper.getReadableDatabase();
		cursor = db.query(UserDBConstants.TABLE_NAME,
			null, null, null, null, null,
			UserDBConstants.Columns.ID + " ASC");

		// Init ListAdapter
		listAdapter = new SimpleCursorAdapter(this,
			android.R.layout.simple_list_item_2, null,
			MAPPING_FROM, MAPPING_TO);
		setListAdapter(listAdapter);

		getListView().setOnItemClickListener(this);

		reload();
	}

	@Override
	protected void onDestroy()
	{
		if (cursor != null)
		{
			cursor.close();
			cursor = null;
		}
		if (db != null)
		{
			db.close();
			db = null;
		}
		super.onDestroy();
	}

	private void reload()
	{
		if (db != null)
		{
			Cursor newCursor = db.query(UserDBConstants.TABLE_NAME,
				null, null, null, null, null,
				UserDBConstants.Columns.ID + " ASC");
			swapCursor(newCursor);
		}
	}

	private void swapCursor(Cursor newCursor)
	{
		listAdapter.changeCursor(newCursor);
		if (cursor != null)
		{
			cursor.close();
		}
		cursor = newCursor;
	}

	private void startUserDetailActivity(long id)
	{
		Intent intent = new Intent(this, UserDetailActivity.class);
		intent.putExtra(UserDetailActivity.EXTRA_USER_ID, id);
		startActivityForResult(intent, REQUEST_USER_DETAIL_EDIT);
	}

	private void startUserDetailActivity()
	{
		startUserDetailActivity(-1);
	}
}
