package com.example.hello.android.textview_find_word_hello;

import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 *
 * @author sawai
 */
public class TextViewSearchContext
{

	private static final String LOG_TAG = "XXX";

	class FoundWord
	{

		int lineNumber;
		int startIndex;
		int endIndex;
	}

	String contentText = "";
	String searchWord = "";
	String[] contentTextLines;
	FoundWord[] foundWords = new FoundWord[0];
	int selectedWordIndex = 0;

	public void setSearchWord(CharSequence serachWord)
	{
		this.searchWord = serachWord.toString();
		this.selectedWordIndex = 0;
		updateContext();
	}

	public void setContentText(CharSequence contentText)
	{
		this.contentText = contentText.toString();
		this.selectedWordIndex = 0;
		updateContext();
	}

	public void prevWord()
	{
		if (foundWords.length > 0)
		{
			selectedWordIndex--;
			if (selectedWordIndex < 0)
			{
				selectedWordIndex = foundWords.length - 1;
			}
		}
	}

	public void nextWord()
	{
		if (foundWords.length > 0)
		{
			selectedWordIndex++;
			if (selectedWordIndex >= foundWords.length)
			{
				selectedWordIndex = 0;
			}
		}
	}

	public int getContentTextLineCount()
	{
		int lineCount = 0;
		if (contentTextLines != null)
		{
			lineCount = contentTextLines.length;
		}
		return lineCount;
	}

	public int getSelectedWordLineNumber()
	{
		int lineNumber = -1;
		if (foundWords.length > 0)
		{
			lineNumber = foundWords[selectedWordIndex].lineNumber;
		}
		return lineNumber;
	}

	private void updateContext()
	{
		contentTextLines = this.contentText.split("\n");

		List<FoundWord> foundWordList = new ArrayList<FoundWord>();
		if (TextUtils.isEmpty(this.searchWord) == false)
		{
			for (int i = 0; i < contentTextLines.length; i++)
			{
				String line = contentTextLines[i];
				Pattern p = Pattern.compile(this.searchWord, Pattern.CASE_INSENSITIVE);
				Matcher m = p.matcher(line);
				while (m.find())
				{
					FoundWord foundWord = new FoundWord();
					foundWord.lineNumber = i;
					foundWord.startIndex = m.start();
					foundWord.endIndex = m.end();
					foundWordList.add(foundWord);
					Log.v(LOG_TAG, "foundWord => " + foundWord);
					Log.v(LOG_TAG, "foundWord.startIndex => " + foundWord.startIndex);
					Log.v(LOG_TAG, "foundWord.endIndex => " + foundWord.endIndex);
				}
			}
		}
		this.foundWords = foundWordList.toArray(new FoundWord[0]);
	}

	public Spannable getSpannable()
	{
		Log.v(LOG_TAG, "selectedWordIndex => " + selectedWordIndex);
		SpannableStringBuilder builder = new SpannableStringBuilder();
		for (int i = 0; i < contentTextLines.length; i++)
		{
			int lineHeadIndex = builder.length();
			builder.append(this.contentTextLines[i]);

			for (int j = 0; j < foundWords.length; j++)
			{
				FoundWord foundWord = foundWords[j];
				if (foundWord.lineNumber == i)
				{
					int startIndex = lineHeadIndex + foundWord.startIndex;
					int endIndex = lineHeadIndex + foundWord.endIndex;
//					Log.v(LOG_TAG, "lineHeadIndex => " + lineHeadIndex);
//					Log.v(LOG_TAG, "startIndex => " + startIndex);
//					Log.v(LOG_TAG, "endIndex => " + endIndex);
					if (j == selectedWordIndex)
					{
						builder.setSpan(new BackgroundColorSpan(0xFFAA00AA), startIndex, endIndex, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
						builder.setSpan(new ForegroundColorSpan(0xFFFFFFFF), startIndex, endIndex, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
					}
					else
					{
						builder.setSpan(new BackgroundColorSpan(0xFF8B008B), startIndex, endIndex, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
						builder.setSpan(new ForegroundColorSpan(0xFFFFFFFF), startIndex, endIndex, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);

					}
				}
			}

			builder.append("\n");
		}

		return builder;
	}
}
