/*
 * The MIT License
 *
 * Copyright 2013 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.textview_find_word_hello;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ScrollView;
import android.widget.TextView;

public class MainActivity extends Activity
	implements TextWatcher, TextView.OnEditorActionListener, View.OnClickListener
{

	private static final String LOG_TAG = "XXX";
	private final TextViewSearchContext searchContext = new TextViewSearchContext();
	private TextView helloTextView;
	private ScrollView helloScrollView;

	@Override
	public void onCreate(Bundle savedInstanceState)
	{
		Log.v(LOG_TAG, "onCreate() : Hello");

		super.onCreate(savedInstanceState);
		setContentView(R.layout.main_activity);

		helloTextView = (TextView) findViewById(R.id.hello_textview);

		helloScrollView = (ScrollView) findViewById(R.id.hello_scrollview);

		EditText findWordEditText = (EditText) findViewById(R.id.find_word_edittext);
		findWordEditText.setOnEditorActionListener(this);

		ImageButton findWordButton = (ImageButton) findViewById(R.id.find_word_button);
		findWordButton.setOnClickListener(this);

		ImageButton cancelSearchButton = (ImageButton) findViewById(R.id.cancel_search_button);
		cancelSearchButton.setOnClickListener(this);

		ImageButton findPrevButton = (ImageButton) findViewById(R.id.find_prev_button);
		findPrevButton.setOnClickListener(this);

		ImageButton findNextButton = (ImageButton) findViewById(R.id.find_next_button);
		findNextButton.setOnClickListener(this);

		setText(helloTextView.getText());

		Log.v(LOG_TAG, "onCreate() : Bye");
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu)
	{
		MenuInflater menuInflater = getMenuInflater();
		menuInflater.inflate(R.menu.find_word_option_menu, menu);
		menuInflater.inflate(R.menu.quit_menu, menu);

		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item)
	{
		boolean result;
		int itemId = item.getItemId();
		switch (itemId)
		{
			case R.id.find_word_menuitem:
				enterSearchMode();
				result = true;
				break;
			case R.id.quit_menuitem:
				finish();
				result = true;
				break;
			default:
				result = super.onOptionsItemSelected(item);
		}
		return result;
	}

	@Override
	public void beforeTextChanged(CharSequence cs, int i, int i1, int i2)
	{
		Log.v(LOG_TAG, "beforeTextChanged() : Hello");
		Log.v(LOG_TAG, "beforeTextChanged() : Bye");
	}

	@Override
	public void onTextChanged(CharSequence cs, int i, int i1, int i2)
	{
		Log.v(LOG_TAG, "onTextChanged() : Hello");
		Log.v(LOG_TAG, "onTextChanged() : i => " + i + ", i1 => " + i1 + ", i2 => " + i2);
		setSearchWord(cs);
		Log.v(LOG_TAG, "onTextChanged() : Bye");
	}

	@Override
	public void afterTextChanged(Editable edtbl)
	{
		Log.v(LOG_TAG, "afterTextChanged() : Hello");
		Log.v(LOG_TAG, "afterTextChanged() : Bye");
	}

	private void setText(CharSequence text)
	{
		this.searchContext.setContentText(text);
		updateView();
	}

	private void setSearchWord(CharSequence searchWord)
	{
		this.searchContext.setSearchWord(searchWord);
		updateView();
	}

	private void findPrevWord()
	{
		searchContext.prevWord();
		updateView();
	}

	private void findNextWord()
	{
		searchContext.nextWord();
		updateView();
	}

	private void updateView()
	{
		this.helloTextView.setText(this.searchContext.getSpannable());

		int selectedWordLineNumber = this.searchContext.getSelectedWordLineNumber();
		Log.d(LOG_TAG, "selectedWordLineNumber => " + selectedWordLineNumber);
		if (selectedWordLineNumber >= 0)
		{
			Rect rect = new Rect();
			helloTextView.getLineBounds(selectedWordLineNumber, rect);
			helloScrollView.scrollTo(rect.left, rect.top - helloTextView.getLineHeight());
		}

	}

	public boolean onEditorAction(TextView textView, int actionId, KeyEvent keyEvent)
	{
		if (actionId == EditorInfo.IME_ACTION_SEARCH)
		{
			setSearchWord(textView.getText());
			closeIMEWindow(textView);
		}
		return true;
	}

	private void enterSearchMode()
	{
		View defauiltActionBar = findViewById(R.id.detault_actionbar_container);
		defauiltActionBar.setVisibility(View.GONE);

		View searchActionBar = findViewById(R.id.search_actionbar_container);
		searchActionBar.setVisibility(View.VISIBLE);
	}

	private void leaveSearchMode()
	{
		View defauiltActionBar = findViewById(R.id.detault_actionbar_container);
		defauiltActionBar.setVisibility(View.VISIBLE);

		View searchActionBar = findViewById(R.id.search_actionbar_container);
		searchActionBar.setVisibility(View.GONE);

		EditText findWordEditText = (EditText) findViewById(R.id.find_word_edittext);
		findWordEditText.setText("");
		searchContext.setSearchWord("");
	}

	private void openIMEWindow(View view)
	{
		InputMethodManager inputMethodManager = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
		inputMethodManager.showSoftInput(view, InputMethodManager.SHOW_IMPLICIT);
	}

	private void closeIMEWindow(View view)
	{
		InputMethodManager inputMethodManager = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
		inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
	}

	public void onClick(View view)
	{
		switch (view.getId())
		{
			case R.id.find_word_button:
				enterSearchMode();
				break;
			case R.id.cancel_search_button:
				leaveSearchMode();
				break;
			case R.id.find_prev_button:
				findPrevWord();
				break;
			case R.id.find_next_button:
				findNextWord();
				break;
			default:
				throw new AssertionError();
		}
	}

}
