package com.example.hello.android.markdown_viewer;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.text.Html;
import android.text.Spanned;
import android.util.Log;
import android.webkit.WebView;
import android.widget.TextView;
import com.petebevin.markdown.MarkdownProcessor;

public class MarkdownViewerActivity extends Activity
{
	private static final String LOG_TAG = "XXX";

	@Override
	public void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.markdown_viewer_activity);

		Intent intent = getIntent();
		String markdownText = intent.getStringExtra(Intent.EXTRA_TEXT);
		setMarkdownText(markdownText);
	}

	private void setMarkdownText(String markdownText)
	{
		MarkdownProcessor processor = new MarkdownProcessor();
		String htmlSourceText = processor.markdown(markdownText);
		Log.d(LOG_TAG, "htmlSourceText => " + htmlSourceText);

		WebView viewerWebView = (WebView) findViewById(R.id.viewer_webview);
		viewerWebView.loadData(htmlSourceText, "text/html; charset=utf-8", "utf-8");

	}
}
