/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.listview_simple_cursor_adapter;

import android.app.ListActivity;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.widget.EditText;
import android.widget.SimpleCursorAdapter;

public class MainActivity extends ListActivity implements UserDBConstants,
	TextWatcher
{

	private static final String LOG_TAG = "XXX";
	private static final String[] MAPPING_FROM = new String[]
	{
		Columns.NAME,
		Columns.EMAIL,
	};
	private static final int[] MAPPING_TO = new int[]
	{
		R.id.name_textview, R.id.email_textview
	};
	private SimpleCursorAdapter userListAdapter;
	private UserDBHelper dbHelper;
	private SQLiteDatabase db;
	private Cursor cursor;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main_activity);
		dbHelper = new UserDBHelper(this);

		EditText searchWordEditText = (EditText) findViewById(R.id.search_word_edittext);
		searchWordEditText.addTextChangedListener(this);

		// Init ListAdapter
		userListAdapter = new SimpleCursorAdapter(this,
			R.layout.user_list_item,
			null, MAPPING_FROM, MAPPING_TO);
		setListAdapter(userListAdapter);
	}

	@Override
	protected void onStart()
	{
		Log.v(LOG_TAG, "onStart() : Hello");
		super.onStart();
		db = dbHelper.getReadableDatabase();
		Log.v(LOG_TAG, "onStart() : Bye");
	}

	@Override
	protected void onStop()
	{
		Log.v(LOG_TAG, "onStop() : Hello");
		if (db != null)
		{
			db.close();
			db = null;
		}
		super.onStop();
		Log.v(LOG_TAG, "onStop() : Bye");
	}

	@Override
	protected void onResume()
	{
		Log.v(LOG_TAG, "onResume() : Hello");

		super.onResume();
		updateUserList();

		Log.v(LOG_TAG, "onResume() : Bye");
	}

	@Override
	protected void onPause()
	{
		Log.v(LOG_TAG, "onPause() : Hello");

		if (cursor != null)
		{
			cursor.close();
			cursor = null;
		}
		super.onPause();

		Log.v(LOG_TAG, "onPause() : Bye");
	}

	@Override
	public void beforeTextChanged(CharSequence s, int start, int count, int after)
	{
	}

	@Override
	public void onTextChanged(CharSequence s, int start, int before, int count)
	{
		updateUserList(s);
	}

	@Override
	public void afterTextChanged(Editable edit)
	{
	}

	private void updateUserList(CharSequence searchWord)
	{
		Log.v(LOG_TAG, "updateUserList() : Hello");
		Log.v(LOG_TAG, "updateUserList() : searchWord => " + searchWord);
		Cursor newCursor = dbHelper.selectUsersByName(db, searchWord);
		swapCursor(newCursor);
		Log.v(LOG_TAG, "updateUserList() : Bye");
	}

	private void updateUserList()
	{
		EditText findViewById = (EditText) findViewById(R.id.search_word_edittext);
		updateUserList(findViewById.getText().toString());
	}

	private void swapCursor(Cursor newCursor)
	{
		userListAdapter.changeCursor(newCursor);

		if (cursor != null)
		{
			cursor.close();
		}
		cursor = newCursor;
	}
}
