package com.example.hello.android.animated_gif_encoder_hello;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Environment;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.Toast;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;

public class MainActivity extends Activity
{

	private static final String LOG_TAG = "XXX";
	private static final String IMAGE_DIRECTORY_NAME = "amimated-gif-encoder-test";
	private static final File IMAGE_DIRECTORY_PATH = new File(Environment.getExternalStorageDirectory(), IMAGE_DIRECTORY_NAME);
	private static final int WIDTH = 320;
	private static final int HEIGHT = 320;
	private static final int FRAMES = 30;

	@Override
	public void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main_activity);
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu)
	{
		MenuInflater menuInflater = getMenuInflater();
		menuInflater.inflate(R.menu.save_menu, menu);
		menuInflater.inflate(R.menu.quit_menu, menu);

		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item)
	{
		boolean result = true;

		switch (item.getItemId())
		{
			case R.id.save_menuitem:
				new SaveAnimatedGifFileTask().execute();
				break;
			case R.id.quit_menuitem:
				finish();
				break;
			default:
				result = super.onOptionsItemSelected(item);
		}
		return result;
	}

	class SaveAnimatedGifFileTask extends AsyncTask<Void, Void, Void>
	{

		@Override
		protected Void doInBackground(Void... paramss)
		{
			try
			{
				saveAnimatedGifFile();
			}
			catch (FileNotFoundException ex)
			{
				Log.e(LOG_TAG, "Error : ", ex);
			}
			return null;
		}

		@Override
		protected void onPostExecute(Void result)
		{
			Context applicationContext = getApplicationContext();
			if (applicationContext != null)
			{
				Toast.makeText(applicationContext, "SaveAnimatedGifFileTask is done.", Toast.LENGTH_SHORT).show();
			}
		}

		private void saveAnimatedGifFile() throws FileNotFoundException
		{
			Log.d(LOG_TAG, "saveAnimatedGifFile() : Hello!");

			// Init Bitmap and Canvas
			Bitmap bitmap = Bitmap.createBitmap(WIDTH, HEIGHT, Bitmap.Config.ARGB_8888);
			Log.d(LOG_TAG, "saveAnimatedGifFile() : bitmap => " + bitmap);

			Paint green = new Paint();
			green.setColor(Color.GREEN);
			green.setAntiAlias(true);

			Paint black = new Paint();
			black.setColor(Color.BLACK);
			black.setAntiAlias(true);

			Paint[] fgPaints = new Paint[]
			{
				green, black
			};

			Canvas canvas = new Canvas(bitmap);
			canvas.drawRect(0, 0, WIDTH, HEIGHT, black);

			// Init GIF encoder
			if (IMAGE_DIRECTORY_PATH.exists() == false)
			{
				Log.d(LOG_TAG, "saveImage() : create directory " + IMAGE_DIRECTORY_PATH);
				boolean result = IMAGE_DIRECTORY_PATH.mkdirs();
				Log.d(LOG_TAG, "saveImage() : mkdirs result " + result);
			}
			File animatedGifFilePath = new File(IMAGE_DIRECTORY_PATH, "hello.gif");
			FileOutputStream fileOutputStream = new FileOutputStream(animatedGifFilePath);
			BufferedOutputStream bos = new BufferedOutputStream(fileOutputStream);
			AnimatedGifEncoder animatedGifEncoder = new AnimatedGifEncoder();
			animatedGifEncoder.setSize(WIDTH, HEIGHT);
			animatedGifEncoder.setDelay(60);
			animatedGifEncoder.setRepeat(0);
			animatedGifEncoder.start(bos);

			for (Paint fgPaint : fgPaints)
			{
				// render and add frame
				for (int i = 0; i < FRAMES; i++)
				{
					canvas.drawCircle(WIDTH / 2, HEIGHT / 2, WIDTH * i / FRAMES, fgPaint);
					animatedGifEncoder.addFrame(bitmap);
				}
			}

			animatedGifEncoder.finish();

			bitmap.recycle();

			Log.d(LOG_TAG, "saveAnimatedGifFile() : Bye!");
		}

	}

}
