/*
 *  The MIT License
 *
 *  Copyright 2012 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package com.example.hello.android.event_keyboard;

import android.app.ListActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.widget.SimpleAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MainActivity extends ListActivity
{

	private static final String LOG_TAG = "XXX";
	private static final int EVENT_COUNT_MAX = 100;
	private static final String MAP_KEY_ACTION = "ACTION";
	private static final String MAP_KEY_KEYCODE = "KEYCODE";
	private static final String MAP_KEY_SCANCODE = "SCANCODE";
	private static final String[] MAPPING_FROM =
	{
		MAP_KEY_ACTION,
		MAP_KEY_KEYCODE,
		MAP_KEY_SCANCODE,
	};
	private static final int[] MAPPING_TO =
	{
		R.id.action_textview,
		R.id.keycode_textview,
		R.id.scancode_textview,
	};
	private List<Map<String, String>> keyEventList;
	private SimpleAdapter listAdapter;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		Log.v(LOG_TAG, "onCreate() : Hello");

		super.onCreate(savedInstanceState);
		setContentView(R.layout.main_activity);

		keyEventList = new ArrayList<Map<String, String>>();
		listAdapter = new SimpleAdapter(this, keyEventList,
			R.layout.key_event_list_item, MAPPING_FROM, MAPPING_TO);
		setListAdapter(listAdapter);

		Log.v(LOG_TAG, "onCreate() : Bye");
	}

	@Override
	public boolean onKeyDown(int keyCode, KeyEvent keyEvent)
	{
		appendKeyEvent(keyEvent);
		return super.onKeyDown(keyCode, keyEvent);
	}

	@Override
	public boolean onKeyMultiple(int keyCode, int repeatCount, KeyEvent keyEvent)
	{
		appendKeyEvent(keyEvent);
		return super.onKeyMultiple(keyCode, repeatCount, keyEvent);
	}

	@Override
	public boolean onKeyUp(int keyCode, KeyEvent keyEvent)
	{
		appendKeyEvent(keyEvent);

		return super.onKeyUp(keyCode, keyEvent);
	}

	private static String getActionTexgt(KeyEvent keyEvent)
	{
		String actionName = "";
		switch (keyEvent.getAction())
		{
			case KeyEvent.ACTION_DOWN:
				actionName = "DOWN";
				break;
			case KeyEvent.ACTION_UP:
				actionName = "UP";
				break;
			case KeyEvent.ACTION_MULTIPLE:
				actionName = "MULTIPLE";
				break;
		}

		return actionName;
	}

	private static String getKeyCodeText(KeyEvent keyEvent)
	{
		String keyCodeText = "";
		Pattern pattern = Pattern.compile("keyCode=([\\w_]+)");
		Matcher matcher = pattern.matcher(keyEvent.toString());
		if (matcher.find())
		{
			keyCodeText = matcher.group(1);
		}

		return keyCodeText;
	}

	private void appendKeyEvent(KeyEvent keyEvent)
	{
		Log.d(LOG_TAG, "keyEvent => " + keyEvent);
		Map<String, String> data = new HashMap<String, String>();
		data.put(MAP_KEY_ACTION, getActionTexgt(keyEvent));
		data.put(MAP_KEY_KEYCODE, getKeyCodeText(keyEvent));
		data.put(MAP_KEY_SCANCODE, String.valueOf(keyEvent.getScanCode()));
		keyEventList.add(0, data);
		if (keyEventList.size() > EVENT_COUNT_MAX)
		{
			keyEventList.remove(EVENT_COUNT_MAX);
		}
		listAdapter.notifyDataSetChanged();
	}
}
