package com.example.hello.android.confirm_credential_hello;

import android.app.Activity;
import android.app.KeyguardManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;

public class MainActivity extends Activity
{

	private static final int REQUEST_CODE_CONFIRM_DEVICE_CREDENTIALS = 1;

	private KeyguardManager mKeyguardManager;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main_activity);

		Button unlockButton = (Button) findViewById(R.id.unlock_button);

		mKeyguardManager = (KeyguardManager) getSystemService(Context.KEYGUARD_SERVICE);
		if (!mKeyguardManager.isKeyguardSecure())
		{
			// Show a message that the user hasn't set up a lock screen.
			Toast.makeText(this,
				"Secure lock screen hasn't set up.\n"
				+ "Go to 'Settings -> Security -> Screenlock' to set up a lock screen",
				Toast.LENGTH_LONG).show();
			unlockButton.setEnabled(false);
			return;
		}

		unlockButton.setOnClickListener(new View.OnClickListener()
		{
			@Override
			public void onClick(View v)
			{
				// Test to encrypt something. It might fail if the timeout expired (30s).
				showAuthenticationScreen();
			}
		});

		Button lockButton = (Button) findViewById(R.id.lock_button);
		lockButton.setOnClickListener(new View.OnClickListener()
		{
			@Override
			public void onClick(View v)
			{
				lockItem();
			}

		});
	}

	private void showAuthenticationScreen()
	{
		// Create the Confirm Credentials screen. You can customize the title and description. Or
		// we will provide a generic one for you if you leave it null
		Intent intent = mKeyguardManager.createConfirmDeviceCredentialIntent(null, null);
		if (intent != null)
		{
			startActivityForResult(intent, REQUEST_CODE_CONFIRM_DEVICE_CREDENTIALS);
		}
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data)
	{
		if (requestCode == REQUEST_CODE_CONFIRM_DEVICE_CREDENTIALS)
		{
			// Challenge completed, proceed with using cipher
			if (resultCode == RESULT_OK)
			{
				unlockItem();
			}
			else
			{
				lockItem();
			}
		}
	}

	private void lockItem()
	{
		findViewById(R.id.locked_text).setVisibility(View.VISIBLE);
		findViewById(R.id.unlocked_text).setVisibility(View.GONE);
		findViewById(R.id.lock_button).setEnabled(false);
		findViewById(R.id.unlock_button).setEnabled(true);
	}

	private void unlockItem()
	{
		findViewById(R.id.locked_text).setVisibility(View.GONE);
		findViewById(R.id.unlocked_text).setVisibility(View.VISIBLE);
		findViewById(R.id.lock_button).setEnabled(true);
		findViewById(R.id.unlock_button).setEnabled(false);
	}

}
