/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.activity_manager_running_tasks_list;

import android.app.ActivityManager;
import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;
import java.util.List;

public class TaskListAdapter extends ArrayAdapter<ActivityManager.RunningTaskInfo>
{

	private LayoutInflater inflater;
	private static final String LOG_TAG = "XXX";

	public TaskListAdapter(Context context, List<ActivityManager.RunningTaskInfo> taskList)
	{
		super(context, 0, taskList);
		inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent)
	{
		View view;

		if (convertView == null)
		{
			view = inflater.inflate(R.layout.task_list_item, null);
		}
		else
		{
			view = convertView;
		}

		ActivityManager.RunningTaskInfo taskInfo = getItem(position);
		if (taskInfo != null)
		{
			Log.d(LOG_TAG, "thumbnail => " + taskInfo.thumbnail); // => null, always 

			TextView baseActivityNameTextView = (TextView) view.findViewById(R.id.base_activity_name_textview);
			baseActivityNameTextView.setText(taskInfo.baseActivity.getShortClassName());

			TextView topActivityNameTextView = (TextView) view.findViewById(R.id.top_activity_name_textview);
			topActivityNameTextView.setText(taskInfo.topActivity.getShortClassName());

			TextView descriptionTextview = (TextView) view.findViewById(R.id.description_textview);
			descriptionTextview.setText(taskInfo.description);

			TextView idTextView = (TextView) view.findViewById(R.id.id_textview);
			idTextView.setText(String.valueOf(taskInfo.id));

			TextView numActivitiesTextView = (TextView) view.findViewById(R.id.num_activities_textview);
			numActivitiesTextView.setText(String.valueOf(taskInfo.numActivities));

			TextView numRunningActivitiesTextView = (TextView) view.findViewById(R.id.num_running_activities_textview);
			numRunningActivitiesTextView.setText(String.valueOf(taskInfo.numRunning));
		}
		return view;
	}
}
