#include <stdio.h>
#include <string.h>

char* progName( char* argv0 )
{
	char* szTop;
	char* szTmp;
	szTop = argv0;
	if( (szTmp = strrchr( szTop, '\\' )) != NULL )
	{
		szTop = szTmp + 1;
	}
	if( (szTmp = strrchr( szTop, '.' )) != NULL )
	{
		*szTmp = '\0';
	}
	return strlwr( szTop );
}

int main( int argc, char* argv[] )
{
	char file[256 + 1];
	char file2[256 + 1];
	char file3[256 + 1];
	char file4[256 + 1];
	char ext[256 + 1];
	char id[256 + 1];
	char command[256];

	char* szTmp;
	char* szTop;
	FILE* fp;

	if( argc < 2 )
	{
		printf( "usage: %s <in_file>\n", progName( argv[0] ) );
		return 0;
	}

	strcpy( file, argv[1] );

	if( (szTmp = strrchr( file, '.' )) != NULL )
	{
		*szTmp = '\0';
		strcpy( file2, file );
		strcpy( ext, &szTmp[1] );
		*szTmp = '.';
	}

	if( (szTop = strrchr( file2, '\\' )) == NULL )
	{
		szTop = file2;
	}
	else
	{
		szTop++;
	}
	strcpy( id, szTop );
	strcpy( file4, szTop );

	if( (szTop = strrchr( file, '\\' )) == NULL )
	{
		szTop = file;
	}
	else
	{
		*szTop = '\0';
		chdir( file );
		szTop++;
	}
	sprintf( file3, "%s.xml", szTop );

	if( (fp = fopen( file3, "w+t" )) != NULL )
	{
		fprintf( fp, "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n" );
		fprintf( fp, "<movie>\n" );
		fprintf( fp, "  <clip id=\"%s_%s\" import=\"%s\" />\n", strupr( ext ), strupr( id ), szTop );
		fprintf( fp, "  <frame>\n" );
		fprintf( fp, "    <place id=\"%s_%s\" x=\"0\" y=\"0\" depth=\"0\" />\n", strupr( ext ), strupr( id ) );
		fprintf( fp, "  </frame>\n" );
		fprintf( fp, "</movie>\n" );
		fclose( fp );

		sprintf( command, "swfmill simple \"%s\" \"%s.swf\"", file3, file4 );
		printf( "%s\n", command );
		system( command );
	}

	return 0;
}
