#include <stdio.h>
#include <string.h>

char* progName( char* argv0 )
{
	char* szTop;
	char* szTmp;
	szTop = argv0;
	if( (szTmp = strrchr( szTop, '\\' )) != NULL )
	{
		szTop = szTmp + 1;
	}
	if( (szTmp = strrchr( szTop, '.' )) != NULL )
	{
		*szTmp = '\0';
	}
	return strlwr( szTop );
}

int main( int argc, char* argv[] )
{
	register int i;
	int count;
	int top;
	int size;
	FILE* fp;
	unsigned char tmp;

	if( argc < 3 )
	{
		printf( "usage: %s <bin_file> <array_name> [<count>] [<top>] [<size>]\n", progName( argv[0] ) );
		return 0;
	}

	count = 10;
	top = 0;
	size = 0;
	if( argc > 3 )
	{
		count = atol( argv[3] );
	}
	if( argc > 4 )
	{
		top = atol( argv[4] );
	}
	if( argc > 5 )
	{
		size = atol( argv[5] );
	}

	if( (fp = fopen( argv[1], "rb" )) != NULL )
	{
		printf( "var %s:Array = [", argv[2] );
		i = 0;
		while( fread( &tmp, 1, 1, fp ) > 0 )
		{
			if( top > 0 )
			{
				top--;
			}
			else
			{
				if( (size > 0) && (i >= size) )
				{
					break;
				}
				if( i != 0 )
				{
					printf( "," );
				}
				if( (i % count) == 0 )
				{
					printf( "\n\t" );
				}
				printf( "%d", tmp );
				i++;
			}
		}
		printf( "\n];\n" );
		fclose( fp );
	}
	return 0;
}
