#include "_Global.h"

#include "Main.h"

/**
 * メイン
 */
class Main extends _Main {
	var g;

#ifdef _USE_BITMAPDATA
	var bitmap:Array;
#endif // _USE_BITMAPDATA

	var softkey:_SoftKey;

	var rand;

	var stage;
	var _win_x, _win_y;			// ウィンドウ左上座標

	var wave_data;	// ウェーブ情報
#ifdef USE_WAVEDRAWDATA
	var draw_data;	// 描画時の作業用
#endif // USE_WAVEDRAWDATA
	var ring;		// リング情報

	var shot;	// 弾情報

	var jiki_x, jiki_y;		// 位置
	var dsp_x, dsp_y;		// 描画位置
	var _light_x, _light_y;	// 照明の位置
	var pattern_x, pattern_y;
	var _mode;
	var _direction;
	var _barrier;
	var _damage, t_damage, m_damage;
	var _life;
	var _muteki;
	var _img;

	// よく使う色
//	var COLOR_C;
//	var COLOR_M;
//	var COLOR_Y;
//	var COLOR_K;
//	var COLOR_R;
//	var COLOR_G;
//	var COLOR_W;

	// 三角関数テーブル
	var COS = [ 1358, 1176, 679, 0, -678, -1176, -1358, -1176, -679, 0, 679, 1176 ];
	var SIN = [ 0, 678, 1176, 1358, 1176, 678, 0, -679, -1176, -1358, -1176, -679 ];

	var state = STATE_LAUNCH;	// アプリの状態
	var _elapse;				// 経過時間
	var boost = false;		// ブースト中かどうか
	var map = true;			// マップを表示するかどうか
	var quake = 0;				// 振動の残り時間
	var quake_x, quake_y;		// 振動の移動量

	var origin_x, origin_y;

	var clip_x, clip_y;
	var clip_w, clip_h;

	var st_index;				// ステージ番号
	var st_max;				// 選択可能なステージの最大
	var level;					// レベル
	var level_max;				// レベルの最大

	var score = 0, hi_score;	// スコア
	var bonus = 0;				// ボーナス

	var old_score;				// ステージ開始時のスコア
	var bonus_d;				// ボーナス表示用
	var best_s;				// ベストスコア
	var new_s;					// 今回のスコア
	var new_score;			// スコア更新かどうか

	var old_life;				// ステージ開始時の自機のライフ
	var miss;					// ステージ中に受けたダメージ数
	var best_t;				// ベストタイム
	var new_t;					// 今回のタイム
	var new_record;			// 記録更新かどうか

	var dark;				// 闇ステージかどうか

	var so;

	/**
	 * 設定の読み込み
	 */
	function load_config() {
		var i;

		// デフォルト値
		st_index  = 0;
		hi_score  = 68000;
		st_max[0] = 0;
		st_max[1] = 0;
		st_max[2] = 0;
		st_max[3] = 0;
		st_max[4] = 0;
		st_max[5] = 0;
		st_max[6] = 0;
		st_max[7] = 0;
		level     = 0;
		level_max = 0;
		for ( i = 0; i < STAGE_NUM; i++ ) {
			best_s[0][i] = 0;
			best_s[1][i] = 0;
			best_s[2][i] = 0;
			best_s[3][i] = 0;
			best_s[4][i] = 0;
			best_s[5][i] = 0;
			best_s[6][i] = 0;
			best_s[7][i] = 0;
			best_t[0][i] = 99999;
			best_t[1][i] = 99999;
			best_t[2][i] = 99999;
			best_t[3][i] = 99999;
			best_t[4][i] = 99999;
			best_t[5][i] = 99999;
			best_t[6][i] = 99999;
			best_t[7][i] = 99999;
		}

		var str = new String("");
		so.beginRead();
		var version = 0;
		str = so.read(); if ( str.length > 0 ) version = Number(str);
		if ( version == CONFIG_VERSION ) {
			str = so.read(); if ( str.length > 0 ) st_index  = Number(str);
			str = so.read(); if ( str.length > 0 ) hi_score  = Number(str);
			str = so.read(); if ( str.length > 0 ) st_max[0] = Number(str);
			str = so.read(); if ( str.length > 0 ) level     = Number(str);
			str = so.read(); if ( str.length > 0 ) level_max = Number(str);
			str = so.read(); if ( str.length > 0 ) st_max[1] = Number(str);
			for ( i = 0; i < STAGE_NUM; i++ ) {
				str = so.read(); if ( str.length > 0 ) best_s[0][i] = Number(str);
			}
			for ( i = 0; i < STAGE_NUM; i++ ) {
				str = so.read(); if ( str.length > 0 ) best_s[1][i] = Number(str);
			}
			for ( i = 0; i < STAGE_NUM; i++ ) {
				str = so.read(); if ( str.length > 0 ) best_t[0][i] = Number(str);
			}
			for ( i = 0; i < STAGE_NUM; i++ ) {
				str = so.read(); if ( str.length > 0 ) best_t[1][i] = Number(str);
			}
			str = so.read(); if ( str.length > 0 ) st_max[2] = Number(str);
			str = so.read(); if ( str.length > 0 ) st_max[3] = Number(str);
			for ( i = 0; i < STAGE_NUM; i++ ) {
				str = so.read(); if ( str.length > 0 ) best_s[2][i] = Number(str);
			}
			for ( i = 0; i < STAGE_NUM; i++ ) {
				str = so.read(); if ( str.length > 0 ) best_s[3][i] = Number(str);
			}
			for ( i = 0; i < STAGE_NUM; i++ ) {
				str = so.read(); if ( str.length > 0 ) best_t[2][i] = Number(str);
			}
			for ( i = 0; i < STAGE_NUM; i++ ) {
				str = so.read(); if ( str.length > 0 ) best_t[3][i] = Number(str);
			}
			str = so.read(); if ( str.length > 0 ) st_max[4] = Number(str);
			str = so.read(); if ( str.length > 0 ) st_max[5] = Number(str);
			for ( i = 0; i < STAGE_NUM; i++ ) {
				str = so.read(); if ( str.length > 0 ) best_s[4][i] = Number(str);
			}
			for ( i = 0; i < STAGE_NUM; i++ ) {
				str = so.read(); if ( str.length > 0 ) best_s[5][i] = Number(str);
			}
			for ( i = 0; i < STAGE_NUM; i++ ) {
				str = so.read(); if ( str.length > 0 ) best_t[4][i] = Number(str);
			}
			for ( i = 0; i < STAGE_NUM; i++ ) {
				str = so.read(); if ( str.length > 0 ) best_t[5][i] = Number(str);
			}
			str = so.read(); if ( str.length > 0 ) st_max[6] = Number(str);
			str = so.read(); if ( str.length > 0 ) st_max[7] = Number(str);
			for ( i = 0; i < STAGE_NUM; i++ ) {
				str = so.read(); if ( str.length > 0 ) best_s[6][i] = Number(str);
			}
			for ( i = 0; i < STAGE_NUM; i++ ) {
				str = so.read(); if ( str.length > 0 ) best_s[7][i] = Number(str);
			}
			for ( i = 0; i < STAGE_NUM; i++ ) {
				str = so.read(); if ( str.length > 0 ) best_t[6][i] = Number(str);
			}
			for ( i = 0; i < STAGE_NUM; i++ ) {
				str = so.read(); if ( str.length > 0 ) best_t[7][i] = Number(str);
			}
		}
		so.endRead();

		// レベル最大値を設定する
		if ( best_s[0][STAGE_NUM - 1] != 0 ) level_max = 1;
		if ( best_s[1][STAGE_NUM - 1] != 0 ) level_max = 2;
		if ( best_s[2][STAGE_NUM - 1] != 0 ) level_max = 3;
		if ( best_s[3][STAGE_NUM - 1] != 0 ) level_max = 4;
		if ( best_s[4][STAGE_NUM - 1] != 0 ) level_max = 5;
		if ( best_s[5][STAGE_NUM - 1] != 0 ) level_max = 6;
		if ( best_s[6][STAGE_NUM - 1] != 0 ) level_max = 7;
	}

	/**
	 * 設定の書き出し
	 */
	function save_config() {
		var i;
		so.beginWrite();
		so.write("" + CONFIG_VERSION);
		so.write("" + st_index);
		so.write("" + hi_score);
		so.write("" + st_max[0]);
		so.write("" + level);
		so.write("" + level_max);
		so.write("" + st_max[1]);
		for ( i = 0; i < STAGE_NUM; i++ ) {
			so.write("" + best_s[0][i]);
		}
		for ( i = 0; i < STAGE_NUM; i++ ) {
			so.write("" + best_s[1][i]);
		}
		for ( i = 0; i < STAGE_NUM; i++ ) {
			so.write("" + best_t[0][i]);
		}
		for ( i = 0; i < STAGE_NUM; i++ ) {
			so.write("" + best_t[1][i]);
		}
		so.write("" + st_max[2]);
		so.write("" + st_max[3]);
		for ( i = 0; i < STAGE_NUM; i++ ) {
			so.write("" + best_s[2][i]);
		}
		for ( i = 0; i < STAGE_NUM; i++ ) {
			so.write("" + best_s[3][i]);
		}
		for ( i = 0; i < STAGE_NUM; i++ ) {
			so.write("" + best_t[2][i]);
		}
		for ( i = 0; i < STAGE_NUM; i++ ) {
			so.write("" + best_t[3][i]);
		}
		so.write("" + st_max[4]);
		so.write("" + st_max[5]);
		for ( i = 0; i < STAGE_NUM; i++ ) {
			so.write("" + best_s[4][i]);
		}
		for ( i = 0; i < STAGE_NUM; i++ ) {
			so.write("" + best_s[5][i]);
		}
		for ( i = 0; i < STAGE_NUM; i++ ) {
			so.write("" + best_t[4][i]);
		}
		for ( i = 0; i < STAGE_NUM; i++ ) {
			so.write("" + best_t[5][i]);
		}
		so.write("" + st_max[6]);
		so.write("" + st_max[7]);
		for ( i = 0; i < STAGE_NUM; i++ ) {
			so.write("" + best_s[6][i]);
		}
		for ( i = 0; i < STAGE_NUM; i++ ) {
			so.write("" + best_s[7][i]);
		}
		for ( i = 0; i < STAGE_NUM; i++ ) {
			so.write("" + best_t[6][i]);
		}
		for ( i = 0; i < STAGE_NUM; i++ ) {
			so.write("" + best_t[7][i]);
		}
		so.endWrite();
	}

	/**
	 * アプリの状態を変更する
	 */
	function set_state(new_state) {
		var old_state = state;
		state = new_state;
		_elapse = 0;
		boost = false;

		switch ( old_state ) {
		case STATE_TITLE:
			if ( state == STATE_READY ) {
				score = 0;
				bonus = 0;
				jiki_init(true);
			}
			break;
		case STATE_CLEAR:
			add_score(bonus); bonus = 0;
			if ( state != STATE_TITLE ) {
				jiki_init(false);
			}
			st_index++; if ( st_index > st_max[level] ) st_max[level] = st_index;
			save_config();
			break;
		}

		switch ( state ) {
		case STATE_TITLE:
			if ( st_index >= STAGE_NUM ) new_level();
			save_config();
			quake = 0;
			break;
		case STATE_READY:
			map = true;
			old_life = _DIV(t_damage + (WAIT_1 - 1), WAIT_1);
			old_score = score;
			bonus = 6800;
			stage.create();
//			wave_create();
			wave_clear();
			ring.removeAllElements();
//			shots_create();
			shot.removeAllElements();
			break;
		case STATE_CLEAR:
			bonus_d = bonus;
			new_s = (score + bonus_d) - old_score;
			if ( new_s > best_s[level][st_index] ) {
				new_score = (best_s[level][st_index] == 0) ? false : true;
				best_s[level][st_index] = new_s;
			} else {
				new_score = false;
			}
			miss = _DIV(t_damage + (WAIT_1 - 1), WAIT_1) - old_life;
			new_t = (6800 - bonus_d) + 680 * miss;
			if ( new_t < best_t[level][st_index] ) {
				new_record = (best_t[level][st_index] == 99999) ? false : true;
				best_t[level][st_index] = new_t;
			} else {
				new_record = false;
			}
			break;
		}
	}

	/**
	 * 描画に使用する色を設定
	 */
	function setCMYColor(col) {
		switch ( col ) {
		case 0: g.setColor(COLOR_C); break;
		case 1: g.setColor(COLOR_M); break;
		case 2: g.setColor(COLOR_Y); break;
		}
	}

	/**
	 * ウィンドウに対応した各種描画
	 */
	function setOrigin(x, y) {
		origin_x = x;
		origin_y = y;
	}
	function setClip(x, y, w, h) {
		clip_x = x;
		clip_y = y;
		clip_w = w;
		clip_h = h;
	}
	function drawImage(img, x0, y0, w, h) {
		x0 -= _win_x;
		y0 -= _win_y;
		if ( (x0 + w > clip_x) && (x0 < clip_x + clip_w) && (y0 + h > clip_y) && (y0 < clip_y + clip_h) ) {
			x0 += origin_x;
			y0 += origin_y;
#ifdef _USE_BITMAPDATA
			g.drawBitmap(bitmap[img], x0, y0);
#else
			g.drawImage(img, x0, y0);
#endif // _USE_BITMAPDATA
			return true;
		}
		return false;
	}
	function drawScaledImage(img, x0, y0, w, h) {
		x0 -= _win_x;
		y0 -= _win_y;
		x0 += origin_x;
		y0 += origin_y;
#ifdef _USE_BITMAPDATA
		g.drawScaledBitmap(bitmap[img], x0, y0, w, h);
#else
		g.drawScaledImage(img, x0, y0, w, h);
#endif // _USE_BITMAPDATA
	}
	function drawLine(x0, y0, x1, y1) {
		x0 -= _win_x;
		y0 -= _win_y;
		x1 -= _win_x;
		y1 -= _win_y;
		if (
		((x0 > clip_x) && (x0 < clip_x + clip_w) && (y0 > clip_y) && (y0 < clip_y + clip_h)) ||
		((x1 > clip_x) && (x1 < clip_x + clip_w) && (y1 > clip_y) && (y1 < clip_y + clip_h))
		) {
			x0 += origin_x;
			y0 += origin_y;
			x1 += origin_x;
			y1 += origin_y;
			g.drawLine(x0, y0, x1, y1);
		}
	}
	function drawRect(x, y, w, h) {
		x -= _win_x;
		y -= _win_y;
		if ( (x + w > clip_x) && (x < clip_x + clip_w) && (y + h > clip_y) && (y < clip_y + clip_h) ) {
			x += origin_x;
			y += origin_y;
			g.drawRect(x, y, w, h);
		}
	}

	/**
	 * start
	 */
	function start() {
		var i;

		origin_x = 0;
		origin_y = 0;

		g = getGraphics();

#ifdef _USE_BITMAPDATA
		bitmap = new Array(IMAGE_NUM);
		for ( i = 0; i < IMAGE_NUM; i++ ) {
			bitmap[i] = new _BitmapData(this, i);
		}
#endif // _USE_BITMAPDATA

		softkey = new _SoftKey(16);
		softkey.add( 40, 240, 40, 40, _KEY_UP   , -1);
		softkey.add(  0, 280, 40, 40, _KEY_LEFT , -1);
		softkey.add( 80, 280, 40, 40, _KEY_RIGHT, -1);
		softkey.add( 40, 320, 40, 40, _KEY_DOWN , -1);
		softkey.add(140, 320, 40, 40, _KEY_Z    , -1);
		softkey.add(170, 280, 40, 40, _KEY_X    , -1);
		softkey.add(200, 240, 40, 40, _KEY_C    , -1);
		setSoftKey(softkey);

		// よく使う色
//		COLOR_C = g.getColorOfRGB(  0, 255, 255);
//		COLOR_M = g.getColorOfRGB(255,   0, 255);
//		COLOR_Y = g.getColorOfRGB(255, 255,   0);
//		COLOR_K = g.getColorOfRGB(  0,   0,   0);
//		COLOR_R = g.getColorOfRGB(255,   0,   0);
//		COLOR_G = g.getColorOfRGB(  0, 255,   0);
//		COLOR_W = g.getColorOfRGB(255, 255, 255);

		set_state(STATE_LAUNCH);

		st_max = new Array(8);
		best_s = new Array(8);
		best_t = new Array(8);
		for ( i = 0; i < 8; i++ ) {
			best_s[i] = new Array(STAGE_NUM);
			best_t[i] = new Array(STAGE_NUM);
		}

		rand = new _Random();

		stage = new MyStage(this);

		wave_data = new Array(18);
		for ( i = 0; i < 18; i++ ) {
			wave_data[i] = new Array(18);
		}
#ifdef USE_WAVEDRAWDATA
		draw_data = new Array(18);
		for ( i = 0; i < 18; i++ ) {
			draw_data[i] = new Array(18);
		}
#endif // USE_WAVEDRAWDATA
		ring = new _Vector(128);

		shot = new _Vector(128);

		m_damage = WAIT_1 * JIKI_LIFE;
		jiki_init(true);

		so = new _SharedObject(this, "config");
		load_config();

		stage.create();

		set_state(STATE_TITLE);

		return true;
	}

	// スコア加算
	function add_score(point) { score += point; if ( score > hi_score ) hi_score = score; }
	function add_bonus(point) { add_score(point); bonus -= point; }

	// ステージ番号を直す
	function stage_update() { if ( st_index > st_max[level] ) st_index = st_max[level]; }

	/**
	 * レベルを上げる
	 */
	function new_level() {
		level++; if ( level > 7 ) level = 0;
		if ( level > level_max ) level_max = level;
		st_index = 0;
	}

	/**
	 * 文字列センタリング描画
	 */
	function centerDrawString(str, type, y) {
		g.setFont(type);
		g.drawString(str,
			_DIV(240 - g.stringWidth(str), 2),
			y + _DIV(g.fontHeight(), 2)
			);
	}

	/**
	 *
	 */
	function drawStatusSub(str, x, y) {
		g.setFont(_FONT_SMALL);
		g.drawString(str, x - g.stringWidth(str), y);
	}

	/**
	 * ステージ描画
	 */
	function drawStage(title) {
		g.setColor(COLOR_K);
		g.fillRect(0, 0, 240, 240);
		setOrigin(12, 12);
		setClip(0, 0, 216, 216);
		stage.draw(title);

		// クリッピング領域の外を塗りつぶす
		g.setColor(COLOR_K);
		g.fillRect(-240, -240+12, 720, 240);
		g.fillRect(-240+12, 12, 240, 216);
		g.fillRect(240-12, 12, 240, 216);
		g.fillRect(-240, 240-12, 720, 240);
	}

	/**
	 * ステータス描画
	 */
	function drawStatus(title) {
		var y, y2, h, h2;

//		if ( title || !dark ) {
//			g.drawImage(IMAGE_MASK, 0, 0);
//		}

		if ( quake > 0 ) {
			setOrigin(quake_x, quake_y);
		} else {
			setOrigin(0, 0);
		}

		if ( title ) {
			// 上部固定
			y = 0;
			h = 25;
		} else {
			h = 25;
			y = ((jiki_y - _win_y) < (120 - 24)) ? (240 - 25) : 0;
		}

		// スコア
		g.setFont(_FONT_SMALL);
		var h3 = g.fontHeight();
		y2 = (y == 0) ? h : y + h3;
		g.setColor(COLOR_W);
		g.drawString((h3 > 16) ? "SC" : "SCORE", 0, y2);
		drawStatusSub("" + score, 100, y2);
		g.setColor(COLOR_M);
		g.drawString("HI", 106, y2);
		drawStatusSub("" + hi_score, 184, y2);
		g.setColor(boost ? COLOR_Y : COLOR_W);
		g.drawString("T", 190, y2);
		drawStatusSub("" + bonus, 239, y2);

		// ダメージ
		if ( y == 0 ) {
			y2 = 0;
			h2 = h - h3;
		} else {
			y2 = h3;
			h2 = h - y2;
		}
		var w = _DIV(240 * t_damage, m_damage);
		if      ( w < 100 ) { g.setColor(COLOR_G); }
		else if ( w < 200 ) { g.setColor(COLOR_Y); }
		else                { g.setColor(COLOR_R); }
		g.fillRect(0, y + y2, w, h2);
		g.drawRect(0, y + y2, 239, h2 - 1);

		// マップ
		if ( !title && map ) {
			var map_x;
			var map_y;
			map_x = ((jiki_x - _win_x) < 96) ? (240 - 64) : 0;
			if ( y == 0 ) {
				map_y = h;
			} else if ( y == 240 ) {
				map_y = ((jiki_y - _win_y) < 96) ? (240 - 64) : 0;
			} else {
				map_y = y - 64;
			}
			stage.draw_map(map_x, map_y);
		}

		if ( quake > 0 ) {
			setOrigin(0, 0);
		}
	}

	function unlock() {
		var i;
		var left;
		var top;
		var width;
		var height;
		var str;
		g.setFont(_FONT_SMALL);
		g.setColor(g.getColorOfRGB(127, 127, 127));
		g.fillRect(0, 240, 240, 120);
		g.setColor(COLOR_W);
		for ( i = 0; i < softkey.num(); i++ ) {
			left   = softkey.left  (i);
			top    = softkey.top   (i);
			width  = softkey.width (i);
			height = softkey.height(i);
			g.setAlpha(128);
			g.fillRect(left, top, width, height);
			g.setAlpha(255);
			g.drawRect(left, top, width - 1, height - 1);
			str = "";
			switch ( softkey.code(i) ) {
			case _KEY_BACKSPACE: str = "Back"; break;
			case _KEY_TAB      : str = "Tab"; break;
			case _KEY_ENTER    : str = "決定"; break;
			case _KEY_SHIFT    : str = "Shift"; break;
			case _KEY_CTRL     : str = "Ctrl"; break;
			case _KEY_SPACE    : str = "Space"; break;
			case _KEY_LEFT     : str = "←"; break;
			case _KEY_UP       : str = "↑"; break;
			case _KEY_RIGHT    : str = "→"; break;
			case _KEY_DOWN     : str = "↓"; break;
			case _KEY_0        : str = "0"; break;
			case _KEY_1        : str = "1"; break;
			case _KEY_2        : str = "2"; break;
			case _KEY_3        : str = "3"; break;
			case _KEY_4        : str = "4"; break;
			case _KEY_5        : str = "5"; break;
			case _KEY_6        : str = "6"; break;
			case _KEY_7        : str = "7"; break;
			case _KEY_8        : str = "8"; break;
			case _KEY_9        : str = "9"; break;
			case _KEY_C        : str = "C"; break;
			case _KEY_X        : str = "X"; break;
			case _KEY_Z        : str = "Z"; break;
			case _KEY_POUND    : str = "#"; break;
			case _KEY_ASTERISK : str = "*"; break;
			}
			if ( (getKeypadState() & keyBit(softkey.code(i))) != 0 ) {
				g.fillRect(left, top, width, height);
			} else {
				g.drawString(str,
					left + _DIV(width - g.stringWidth(str), 2),
					top + _DIV(height - g.fontHeight(), 2) + g.fontHeight()
					);
			}
		}

#ifdef _DEBUG
		g.setFont(_FONT_TINY);
		g.setColor(g.getColorOfRGB(255, 0, 255));
		g.drawString("use " + g._d, 0, 12);
		g.drawString("create " + g._create, 0, 24);
		g.drawString("attach " + g._attach, 0, 36);
#endif // _DEBUG

		g.unlock();
	}

	/**
	 * paint
	 */
	function paint() {
		var key = getKeypadState();

		if ( quake > 0 ) {
			quake_x = rand.next(_DIV(quake + 2, 3));
			quake_y = rand.next(_DIV(quake + 2, 3));
		}

		switch ( state ) {
		case STATE_LAUNCH:
			g.lock();
			g.setColor(COLOR_K);
			g.fillRect(0, 0, 240, 240);
			setCMYColor(_MOD(_elapse, 3));
			centerDrawString("起動中...", _FONT_SMALL, 120);
			unlock();
			break;
		case STATE_TITLE:
			// 描画
			g.lock();
			drawStage(true);
			drawStatus(true);
			setCMYColor(_MOD(_elapse, 3));
			centerDrawString("TANK BARRIER", _FONT_MEDIUM, 50);
			switch ( level ) {
			case 0:
			case 1:
				g.setColor(COLOR_W);
				break;
			case 2:
			case 3:
				g.setColor(COLOR_C);
				break;
			case 4:
			case 5:
				g.setColor(COLOR_M);
				break;
			case 6:
			case 7:
				g.setColor(COLOR_Y);
				break;
			}
			if ( _MOD(level, 2) == 0 ) {
				centerDrawString("LEVEL EASY", _FONT_SMALL, 90);
			} else {
				centerDrawString("LEVEL HARD", _FONT_SMALL, 90);
			}
			centerDrawString(
				"STAGE " + ((st_index < 9) ? "0" : "") + (st_index + 1),
				_FONT_SMALL,
				115
				);
			g.setColor(COLOR_Y);
			g.drawString("BEST SCORE ", 145 - g.stringWidth("BEST SCORE "), 150);
			if ( best_s[level][st_index] == 0 ) {
				g.drawString("---", 145, 150);
			} else {
				g.drawString(
					"" + best_s[level][st_index],
					145,
					150
					);
			}
			g.drawString("BEST TIME ", 145 - g.stringWidth("BEST TIME "), 170);
			if ( best_t[level][st_index] == 99999 ) {
				g.drawString("---", 145, 170);
			} else {
				g.drawString(
					"" + best_t[level][st_index],
					145,
					170
					);
			}
			g.setColor(COLOR_W);
			if (
			((key & keyBit(_KEY_0)) != 0) ||
			((key & keyBit(_KEY_5)) != 0) ||
			((key & keyBit(_KEY_Z)) != 0) ||
			((key & keyBit(_KEY_X)) != 0) ||
			((key & keyBit(_KEY_C)) != 0)
			) {
				centerDrawString("LOADING...", _FONT_SMALL, 190);
			} else {
				if ( _MOD(_elapse, WAIT_1) <= _DIV(WAIT_1, 2) ) {
					centerDrawString("PRESS [0] OR [5] KEY", _FONT_SMALL, 190);
				}
			}
			centerDrawString("COPYRIGHT (C) SatisKia", _FONT_TINY, 220);
			unlock();

			// キーが押されたらゲームモードへ
			if (
			((key & keyBit(_KEY_0)) != 0) ||
			((key & keyBit(_KEY_5)) != 0) ||
			((key & keyBit(_KEY_Z)) != 0) ||
			((key & keyBit(_KEY_X)) != 0) ||
			((key & keyBit(_KEY_C)) != 0)
			) {
				set_state(STATE_READY);
			}

			break;
		case STATE_READY:
			// 描画
			g.lock();
			drawStage(false);
			jiki_draw(false);
			drawStatus(false);
			g.setColor(COLOR_W);
			centerDrawString(
				"STAGE " + ((st_index < 9) ? "0" : "") + (st_index + 1),
				_FONT_SMALL,
				115
				);
			centerDrawString("R E A D Y", _FONT_SMALL, 135);
			unlock();

			// 一定時間過ぎたらゲーム開始
			if ( _elapse > WAIT_2 ) {
				set_state(STATE_PLAY);
			}

			break;
		case STATE_PLAY:
			// ブースト
			if ( (level < 2) || (level > 3) ) {
				boost = (
					((key & keyBit(_KEY_5)) != 0) ||
					((key & keyBit(_KEY_Z)) != 0) ||
					((key & keyBit(_KEY_X)) != 0) ||
					((key & keyBit(_KEY_C)) != 0)
					) ? true : false;
			}

			if ( bonus > 0 ) {
				bonus -= (boost ? 2 : 1); if ( bonus < 0 ) bonus = 0;
			}

			// 更新
			stage.update(false);
			wave_update();
			shots_update();

			// 自機の移動
			if      ( ((key & keyBit(_KEY_8)) != 0) || ((key & keyBit(_KEY_DOWN )) != 0) ) jiki_down ();
			else if ( ((key & keyBit(_KEY_4)) != 0) || ((key & keyBit(_KEY_LEFT )) != 0) ) jiki_left ();
			else if ( ((key & keyBit(_KEY_6)) != 0) || ((key & keyBit(_KEY_RIGHT)) != 0) ) jiki_right();
			else if ( ((key & keyBit(_KEY_2)) != 0) || ((key & keyBit(_KEY_UP   )) != 0) ) jiki_up   ();
			else jiki_inertia();

			// 自機のダメージ
			if ( wave_hit() || shots_hit() || stage.spear() ) {
				if ( _muteki <= 0 ) {
					if ( _damage == 0 ) _damage++;
				}
			}

			// 描画
			g.lock();
			drawStage(false);
#ifndef WAVE_FULLTIME
			if ( _MOD(_elapse, 2) == 0 ) {
#endif // WAVE_FULLTIME
				wave_draw();
#ifndef WAVE_FULLTIME
			}
#endif // WAVE_FULLTIME
			jiki_draw();
			shots_draw();
			stage.attack();
			drawStatus(false);
			if ( _elapse < WAIT_2 ) {
				g.setColor(COLOR_W);
				centerDrawString("S T A R T !", _FONT_SMALL, 125);
			}
			unlock();

			if ( stage.destroyed() ) {
				// ステージクリア
				set_state(STATE_CLEAR);
			} else if ( t_damage >= m_damage ) {
				// ゲームオーバー
				set_state(STATE_GAMEOVER);
			}

			break;
		case STATE_CLEAR:
			if ( _MOD(bonus, 200) > 0 ) {
				add_bonus(_MOD(bonus, 200));
				_elapse = 0;
			} else if ( bonus >= 200 ) {
				add_bonus(200);
				_elapse = 0;
			}

			// 更新
			stage.update(true);

			// 描画
			g.lock();
			drawStage(false);
			jiki_draw(false);
			drawStatus(false);
			g.setColor(COLOR_W);
			{
				centerDrawString("C L E A R !", _FONT_SMALL, 105);
				var str = new String("");
				str = ((g.fontHeight() > 16) ? "SC " : "SCORE ") + new_s;
				if ( bonus_d > 0 ) {
					str = str + "(BONUS " + bonus_d + ")";
				}
				if ( new_score ) {
					str = str + " UP!";
				}
				centerDrawString(str, _FONT_SMALL, 125);
				str = "TIME " + new_t;
				if ( miss > 0 ) {
					str = str + "(MISS " + miss + ")";
				}
				if ( new_record ) {
					str = str + " UP!";
				}
				centerDrawString(str, _FONT_SMALL, 145);
			}
			unlock();

			// 一定時間過ぎたらゲーム開始
			if ( _elapse > WAIT_2 ) {
				set_state(STATE_READY);
			}

			break;
		case STATE_GAMEOVER:
			// 更新
			stage.update(false);
			if ( _MOD(_elapse, RING_FRAME) == 0 ) {
				wave_update();
			}
			shots_update();

			// 描画
			g.lock();
			drawStage(false);
#ifndef WAVE_FULLTIME
			if ( _MOD(_elapse, 2) == 0 ) {
#endif // WAVE_FULLTIME
				wave_draw();
#ifndef WAVE_FULLTIME
			}
#endif // WAVE_FULLTIME
			jiki_draw(false);
			shots_draw();
			drawStatus(false);
			g.setColor(COLOR_W);
			centerDrawString("G A M E  O V E R", _FONT_SMALL, 125);
			unlock();

			// 一定時間過ぎたらタイトル画面へ
			if ( _elapse > WAIT_4 ) {
				set_state(STATE_TITLE);
			}

			break;
		}

		_elapse++;
		if ( quake > 0 ) quake--;
	}

	function processEvent(type, param) {
		switch ( type ) {
		case _KEY_PRESSED_EVENT:
			switch ( state ) {
			case STATE_LAUNCH:
				break;
			case STATE_TITLE:
				switch ( param ) {
				case _KEY_2:
				case _KEY_UP:
					level--; if ( level < 0 ) level = 0;
					stage_update();
					break;
				case _KEY_8:
				case _KEY_DOWN:
					level++; if ( level > level_max ) level = level_max;
					stage_update();
					break;
				case _KEY_4:
				case _KEY_LEFT:
					st_index--; if ( st_index < 0 ) st_index = 0;
					break;
				case _KEY_6:
				case _KEY_RIGHT:
					st_index++; if ( st_index >= STAGE_NUM ) st_index = STAGE_NUM - 1;
					stage_update();
					break;
				}
				break;
			default:
				switch ( param ) {
				case _KEY_1:
				case _KEY_CTRL:
					map = map ? false : true;
					break;
				case _KEY_3:
				case _KEY_BACKSPACE:
					set_state(STATE_TITLE);
					break;
				case _KEY_ASTERISK:
				case _KEY_Z:
					_barrier = 0;
					break;
				case _KEY_0:
				case _KEY_X:
					_barrier = 1;
					break;
				case _KEY_POUND:
				case _KEY_C:
					_barrier = 2;
					break;
				}
				break;
			}
			break;
		}
	}

	/**
	 * 構築
	 */
//	function shots_create() {
//		shot.removeAllElements();
//	}

	/**
	 * 弾を登録する
	 */
//	function shots_add_shot(x0, y0, x1, y1) {
//		shot.addElement(new Shot(this, x0, y0, x1, y1));
//	}

	/**
	 * 弾を更新する
	 */
	function shots_update() {
		var i;
		var tmp;
		for ( i = shot.size() - 1; i >= 0; i-- ) {
			tmp = shot.elementAt(i);
			tmp.update();

			// 座標判定
			var x = tmp._x;
			var y = tmp._y;
			if ( x <= -12 || x >= 960 || y <= -12 || y >= 960 ) {
				shot.removeElementAt(i);
//			} else if ( stage.kabe12p(_DIV(x + 6, 12), _DIV(y + 6, 12)) ) {
			} else if ( _DIV(stage.base_data[_DIV(_DIV(x + 6, 12), 2)][_DIV(_DIV(y + 6, 12), 2)], stage.base) == BASE_KABE ) {
				shot.removeElementAt(i);
			}
		}
	}

	/**
	 * 当たり判定
	 */
	function shots_hit() {
		var i;
		var _hit = false;
		var x = jiki_x + 6;
		var y = jiki_y + 6;
		var tmp;
		for ( i = shot.size() - 1; i >= 0; i-- ) {
			tmp = shot.elementAt(i);
			if ( (Math.abs(tmp._x - x) < 12) && (Math.abs(tmp._y - y) < 12) ) {
				_hit = true;
				shot.removeElementAt(i);
			}
		}
		return _hit;
	}

	/**
	 * 描画
	 */
	function shots_draw() {
		var i;
		var tmp;
		for ( i = shot.size() - 1; i >= 0; i-- ) {
			tmp = shot.elementAt(i);
			drawImage(IMAGE_SHOT, tmp._x + 1, tmp._y + 1, 10, 10);
		}
	}

	/**
	 * 構築
	 */
//	function wave_create() {
//		wave_clear();
//		ring.removeAllElements();
//	}

	/**
	 * リングを登録する
	 */
//	function wave_add_ring(x, y, col) {
//		ring.addElement(new Ring(this, x, y, col));
//	}

	/**
	 * 点を描く
	 */
	function wave_put12(x0, y0, x1, y1, col) {
		var x2 = x1 - _DIV(_win_x, 12);
		var y2 = y1 - _DIV(_win_y, 12);
		if ( x2 < 0 || x2 >= 18 || y2 < 0 || y2 >= 18 ) return false;
		if ( stage.kabe12l(x0, y0, x1, y1) ) return false;
		wave_data[x2][y2] = col;
		return true;
	}

	/**
	 * クリア
	 */
	function wave_clear() {
		var i, j;
		for ( i = 0; i < 18; i++ ) {
			for ( j = 0; j < 18; j++ ) {
				wave_data[i][j] = -1;
			}
		}
	}

	/**
	 * ウェーブデータ更新
	 */
	function wave_update() {
		var i, j;
		var tmp;

		wave_clear();

		for ( i = ring.size() - 1; i >= 0; i-- ) {
			tmp = ring.elementAt(i);
			if ( _MOD(_elapse, RING_FRAME) == 0 ) {
				tmp.update();
			}

			// 円を描く
			var ret = false;
			var x0 = tmp._x;
			var y0 = tmp._y;
			var r = tmp._elapse;
			var col = tmp._col;
			var x = r;
			var y = 0;
			var f = -2 * r + 3;
			while ( x >= y ) {
				if ( wave_put12(x0, y0, x0 + x, y0 + y, col) ) ret = true;
				if ( wave_put12(x0, y0, x0 - x, y0 + y, col) ) ret = true;
				if ( wave_put12(x0, y0, x0 + x, y0 - y, col) ) ret = true;
				if ( wave_put12(x0, y0, x0 - x, y0 - y, col) ) ret = true;
				if ( wave_put12(x0, y0, x0 + y, y0 + x, col) ) ret = true;
				if ( wave_put12(x0, y0, x0 - y, y0 + x, col) ) ret = true;
				if ( wave_put12(x0, y0, x0 + y, y0 - x, col) ) ret = true;
				if ( wave_put12(x0, y0, x0 - y, y0 - x, col) ) ret = true;
				if ( f >= 0 ) {
					x--;
					f -= 4 * x;
				}
				y++;
				f += 4 * y + 2;
			}

//			if ( r > 113 ) {
				if ( ret == false ) {
					ring.removeElementAt(i);
				}
//			}
		}

		for ( j = 1; j < 17; j++ ) {
			for ( i = 1; i < 17; i++ ) {
				if ( wave_data[i][j] >= 0 ) {
					if (
					(wave_data[i - 1][j - 1] != wave_data[i][j]) &&
					(wave_data[i    ][j - 1] != wave_data[i][j]) &&
					(wave_data[i + 1][j - 1] != wave_data[i][j]) &&
					(wave_data[i - 1][j    ] != wave_data[i][j]) &&
					(wave_data[i + 1][j    ] != wave_data[i][j]) &&
					(wave_data[i - 1][j + 1] != wave_data[i][j]) &&
					(wave_data[i    ][j + 1] != wave_data[i][j]) &&
					(wave_data[i + 1][j + 1] != wave_data[i][j])
					) {
						wave_data[i][j] = -1;
					}
				}
			}
		}
	}

	/**
	 * 当たり判定
	 */
	function wave_hit() {
		var x = _DIV(jiki_x + 6, 12);
		var y = _DIV(jiki_y + 6, 12);
		x -= _DIV(_win_x, 12);
		y -= _DIV(_win_y, 12);
		if ( (wave_data[x    ][y    ] >= 0) && (wave_data[x    ][y    ] != _barrier) ) return true;
		if ( (wave_data[x + 1][y    ] >= 0) && (wave_data[x + 1][y    ] != _barrier) ) return true;
		if ( (wave_data[x    ][y + 1] >= 0) && (wave_data[x    ][y + 1] != _barrier) ) return true;
		if ( (wave_data[x + 1][y + 1] >= 0) && (wave_data[x + 1][y + 1] != _barrier) ) return true;
		return false;
	}

	/**
	 * 描画
	 */
	function wave_draw() {
		var i, j, k, x, y;

		var xx = origin_x - _MOD(_win_x, 12);
		var yy = origin_y - _MOD(_win_y, 12);

		g.setAlpha(192);

#ifdef USE_WAVEDRAWDATA
		// 横に連なっている所を描画
		for ( j = 0; j < 18; j++ ) {
			y = j * 12;
			for ( i = 0; i < 18; ) {
				if ( wave_data[i][j] >= 0 ) {
					for ( k = i + 1; k < 18; k++ ) {
						if ( wave_data[k][j] != wave_data[i][j] ) break;
					}
					if ( k - i > 1 ) {
						setCMYColor(wave_data[i][j]);
						g.fillRect(i * 12 + xx, y + yy, 12 * (k - i), 12);
						for ( ; i < k; i++ ) {
							draw_data[i][j] = -1;
						}
					} else {
						draw_data[i][j] = wave_data[i][j];
						i++;
					}
				} else {
					draw_data[i][j] = -1;
					i++;
				}
			}
		}

		// 縦に連なっている所を描画
		for ( i = 0; i < 18; i++ ) {
			x = i * 12;
			for ( j = 0; j < 18; ) {
				if ( draw_data[i][j] >= 0 ) {
					for ( k = j + 1; k < 18; k++ ) {
						if ( draw_data[i][k] != draw_data[i][j] ) break;
					}
					if ( k - j > 1 ) {
						setCMYColor(draw_data[i][j]);
						g.fillRect(x + xx, j * 12 + yy, 12, 12 * (k - j));
						for ( ; j < k; j++ ) {
							draw_data[i][j] = -1;
						}
					} else {
						j++;
					}
				} else {
					j++;
				}
			}
		}

		// 残った所を描画
		for ( j = 0; j < 18; j++ ) {
			y = j * 12;
			for ( i = 0; i < 18; i++ ) {
				if ( draw_data[i][j] >= 0 ) {
					setCMYColor(draw_data[i][j]);
					g.fillRect(i * 12 + xx, y + yy, 12, 12);
				}
			}
		}
#else
		for ( j = 0; j < 18; j++ ) {
			y = j * 12;
			for ( i = 0; i < 18; i++ ) {
				if ( wave_data[i][j] >= 0 ) {
					setCMYColor(wave_data[i][j]);
					g.fillRect(i * 12 + xx, y + yy, 12, 12);
				}
			}
		}
#endif // USE_WAVEDRAWDATA

		g.setAlpha(255);
	}

	/**
	 * イメージ読み込み
	 */
	function jiki_load_image() {
		switch ( level ) {
		case 0:
		case 1:
			_img = IMAGE_JIKI_0;
			break;
		case 2:
		case 3:
			_img = IMAGE_JIKIP_0;
			break;
		case 4:
		case 5:
			_img = IMAGE_JIKIM_0;
			break;
		case 6:
		case 7:
			_img = IMAGE_JIKID_0;
			break;
		}
	}

	/**
	 * 初期化
	 */
	function jiki_init(start) {
		if ( start ) {
			_life = JIKI_LIFE;
		} else {
			_life++;
			if ( _life <= 0 ) _life = 1;
			if ( _life > JIKI_LIFE ) _life = JIKI_LIFE;
		}
		t_damage = m_damage - (_life * WAIT_1);

		jiki_x     = 468;
		jiki_y     = 924;
		pattern_x  = 0;
		pattern_y  = 0;
		_mode      = BASE_NORMAL;
		_direction = DIRECTION_U;
		jiki_set_dsp();
		jiki_set_light(true);
		_barrier   = 0;
		_damage    = 0;
		_muteki    = 0;
	}

	/**
	 *
	 */
	function jiki_set_dsp() {
		dsp_x = jiki_x;
		dsp_y = jiki_y;
		if ( _mode == BASE_SLOW ) {
			dsp_x += rand.next(3);
			dsp_y += rand.next(3);
		}
	}

	/**
	 *
	 */
	function jiki_set_light(force) {
		if ( dark || force ) {
			_light_x = dsp_x - 48;
			_light_y = dsp_y - 48;
			switch ( _direction ) {
			case DIRECTION_D: _light_y += 36; break;
			case DIRECTION_L: _light_x -= 36; break;
			case DIRECTION_R: _light_x += 36; break;
			case DIRECTION_U: _light_y -= 36; break;
			}
		}
	}

	/**
	 * 下移動
	 */
	function jiki_down() {
		if ( _damage > 0 ) return;
		_direction = DIRECTION_D;
		var old_y = jiki_y;
		switch ( _mode ) {
		case BASE_NORMAL : jiki_y += JIKI_MOVE2; break;
		case BASE_SLOW   : jiki_y += JIKI_MOVE1; break;
		case BASE_INERTIA: jiki_y += JIKI_MOVE2; break;
		}
		_mode = stage.hit(jiki_x, jiki_y);
		if ( _mode == BASE_KABE ) {
			jiki_y = old_y + JIKI_MOVE1;
			_mode = stage.hit(jiki_x, jiki_y);
			if ( _mode == BASE_KABE ) {
				jiki_y = old_y;
			}
		}
		jiki_set_dsp();
		jiki_set_light(false);
		pattern_x--; if ( pattern_x < 0 ) pattern_x = 0;
		pattern_y++; if ( pattern_y > 1 ) pattern_y = 0;
	}

	/**
	 * 左移動
	 */
	function jiki_left() {
		if ( _damage > 0 ) return;
		_direction = DIRECTION_L;
		var old_x = jiki_x;
		switch ( _mode ) {
		case BASE_NORMAL : jiki_x -= JIKI_MOVE2; break;
		case BASE_SLOW   : jiki_x -= JIKI_MOVE1; break;
		case BASE_INERTIA: jiki_x -= JIKI_MOVE2; break;
		}
		_mode = stage.hit(jiki_x, jiki_y);
		if ( _mode == BASE_KABE ) {
			jiki_x = old_x - JIKI_MOVE1;
			_mode = stage.hit(jiki_x, jiki_y);
			if ( _mode == BASE_KABE ) {
				jiki_x = old_x;
			}
		}
		jiki_set_dsp();
		jiki_set_light(false);
		pattern_x++; if ( pattern_x > 4 ) pattern_x = 4;
		pattern_y++; if ( pattern_y > 1 ) pattern_y = 0;
	}

	/**
	 * 右移動
	 */
	function jiki_right() {
		if ( _damage > 0 ) return;
		_direction = DIRECTION_R;
		var old_x = jiki_x;
		switch ( _mode ) {
		case BASE_NORMAL : jiki_x += JIKI_MOVE2; break;
		case BASE_SLOW   : jiki_x += JIKI_MOVE1; break;
		case BASE_INERTIA: jiki_x += JIKI_MOVE2; break;
		}
		_mode = stage.hit(jiki_x, jiki_y);
		if ( _mode == BASE_KABE ) {
			jiki_x = old_x + JIKI_MOVE1;
			_mode = stage.hit(jiki_x, jiki_y);
			if ( _mode == BASE_KABE ) {
				jiki_x = old_x;
			}
		}
		jiki_set_dsp();
		jiki_set_light(false);
		pattern_x++; if ( pattern_x > 4 ) pattern_x = 4;
		pattern_y++; if ( pattern_y > 1 ) pattern_y = 0;
	}

	/**
	 * 上移動
	 */
	function jiki_up() {
		if ( _damage > 0 ) return;
		_direction = DIRECTION_U;
		var old_y = jiki_y;
		switch ( _mode ) {
		case BASE_NORMAL : jiki_y -= JIKI_MOVE2; break;
		case BASE_SLOW   : jiki_y -= JIKI_MOVE1; break;
		case BASE_INERTIA: jiki_y -= JIKI_MOVE2; break;
		}
		_mode = stage.hit(jiki_x, jiki_y);
		if ( _mode == BASE_KABE ) {
			jiki_y = old_y - JIKI_MOVE1;
			_mode = stage.hit(jiki_x, jiki_y);
			if ( _mode == BASE_KABE ) {
				jiki_y = old_y;
			}
		}
		jiki_set_dsp();
		jiki_set_light(false);
		pattern_x--; if ( pattern_x < 0 ) pattern_x = 0;
		pattern_y++; if ( pattern_y > 1 ) pattern_y = 0;
	}

	/**
	 * 慣性移動
	 */
	function jiki_inertia() {
		if ( _mode == BASE_INERTIA ) {
			switch ( _direction ) {
			case DIRECTION_D: jiki_down (); break;
			case DIRECTION_L: jiki_left (); break;
			case DIRECTION_R: jiki_right(); break;
			case DIRECTION_U: jiki_up   (); break;
			}
		}
	}

	// バリアの状態を変更
//	function set_barrier(col) { _barrier = col; }

	// バリアの状態を確認
//	function barrier() { return _barrier; }

	// ダメージを確認
//	function total_damage() { return t_damage; }

	// ダメージ上限を確認
//	function max_damage() { return m_damage; }

	// ライフを確認
//	function life() { return _DIV(t_damage + (WAIT_1 - 1), WAIT_1); }

	// 破壊されたかどうか確認
//	function destroyed() { return (t_damage < m_damage) ? false : true; }

	// 位置を確認
//	function x() { return jiki_x; }
//	function y() { return jiki_y; }

	// 照明の位置を確認
//	function light_x() { return _light_x; }
//	function light_y() { return _light_y; }

	/**
	 * ダメージのトリガー
	 */
//	function damage() {
//		if ( _muteki <= 0 ) {
//			if ( _damage == 0 ) _damage++;
//		}
//	}

	/**
	 * 無敵のトリガー
	 */
//	function muteki() {
//		_muteki = WAIT_2;
//	}

	/**
	 * 描画
	 */
	function jiki_draw() {
		var i;

		// ダメージ中の場合...
		if ( _damage > 0 ) {
			if ( _life > 0 ) {
				drawImage(_img + pattern_y * 5 + pattern_x, dsp_x, dsp_y, 26, 26);
				g.setColor(COLOR_W);
				for ( i = 0; i < 3; i++ ) {
					drawLine(
						dsp_x + 12 + rand.next(13),
						dsp_y + 12 + rand.next(13),
						dsp_x + 12 + rand.next(13),
						dsp_y + 12 + rand.next(13)
						);
				}
				_damage++;
				t_damage++;
				if ( _damage > WAIT_1 ) {
					_damage = 0;
					_life--;
					if ( _life == 0 ) {
						if ( _muteki <= 0 ) {
							if ( _damage == 0 ) _damage++;
						}
					} else {
						_muteki = WAIT_2;
					}
				}
			} else {
				stage.baku(dsp_x, dsp_y, 99, _damage);
				_damage++;
			}
			return;
		}

		// 無敵中の場合...
		if ( _muteki > 0 ) {
			_muteki--;
			if ( _MOD(_muteki, 2) > 0 ) {
				drawImage(_img + pattern_y * 5 + pattern_x, dsp_x, dsp_y, 26, 26);
			}
		} else {
			drawImage(_img + pattern_y * 5 + pattern_x, dsp_x, dsp_y, 26, 26);
		}

		// バリアの表示
		setCMYColor(_barrier);
		drawRect(
			jiki_x - 2 + rand.next(3),
			jiki_y - 2 + rand.next(3),
			26,
			26
			);
	}
}
