#include "_Global.h"

#include "Main.h"

/**
 * ステージ
 */
class MyStage {
	var m;
	var g;

	var _back = -1;		// 背景の種類
	var _col;			// ウェーブの色
	var old_distance;
	var x, _move_x, _offset_x;
	var counter;
	var bar;
#ifdef USE_STAR
	var star;		// 星情報
#endif // USE_STAR

	/**
	 * コンストラクタ
	 */
	function MyStage(m) {
		this.m = m;
		g = m.g;

		back();

#ifdef USE_STAR
		star = new _Vector(128);
#endif // USE_STAR
	}

	function back() {
		var tmp;
		while ( true ) {
			tmp = m.rand.next(4) + 3;
			if ( tmp != _back ) {
				_back = tmp;
				break;
			}
		}
	}

	/**
	 * ステージデータ構築
	 */
	function create() {
		var i;

#ifdef USE_STAR
		star.removeAllElements();
#endif // USE_STAR

		_col = m.rand.next(2) + 1;

		// シールド変更
		if ( m.level == 5 ) {
			m.speeder[0].shield(_col);
		}
		if ( (m.level < 2) || (m.level == 7) ) {
			m.speeder[1].shield(_col);
			m.speeder[2].shield(_col);
		}

#ifdef USE_STAR
		for ( i = 0; i < 240; i += 3 ) {
			star.addElement(new Star(m, 120 + m.rand.next(360), i));
		}
#endif // USE_STAR

		m.wave_add_bar(-100, 192, 3, (m.level != 6) ? 9 : 0, false);
		bar = 1;
		for ( i = 172; i > 0; i -= 20 ) {
			m.wave_add_bar(-100, i, _col, 0, false);
			bar++;
		}

		old_distance = m.speeder[0]._distance;
		x            = -100;
		_move_x      = 0;
		_offset_x    = 0;
		counter      = false;
	}

	/**
	 * ステージデータ更新
	 */
	function update() {
		var i;

#ifdef USE_STAR
		var tmp;
		for ( i = star.size() - 1; i >= 0; i-- ) {
			tmp = star.elementAt(i);
			if ( !tmp.update() ) {
				star.removeElementAt(i);
			}
		}

		if ( m.speeder[0]._speed > 0 ) {
			star.addElement(new Star(m, 120 + m.rand.next(360), 0));
		}
#endif // USE_STAR

		if ( m.level != 6 ) {
			for ( i = 0; i < 3; i++ ) {
				if (
				((i == 0) && m.wave_clear()) ||
				((i != 0) && (m.speeder[i]._distance > (DISTANCE + 2400)))
				) {
					m.speeder[i].speed_down_v(10);
				} else {
					m.speeder[i].speed_up_v(1);
				}
				m.speeder[i]._distance += m.speeder[i]._speed;
				if ( (m.level >= 2) && (m.level <= 6) ) break;
			}
		} else {
			if ( m.speeder[0]._speed < 300 ) {
				m.speeder[0].speed_down_v(5);
			}
			m.speeder[0]._distance += m.speeder[0]._speed;
		}

		if ( counter ) {
			if ( (m.speeder[0]._distance - old_distance) >= 240 ) {
				m.wave_add_bar(x, 0, 3, 9 - _DIV(m.speeder[0]._distance, _DIV(DISTANCE, 9)), false);
				bar++;
				if ( bar >= 12 ) {
					bar = 0;
					counter = false;
				}
				old_distance = m.speeder[0]._distance;
			}
		} else {
			if ( bar > 20 ) {
				bar = 0;

				m.change_col = (m.level == 7) ? 1 : 2;

				switch ( m.level ) {
				case 0:
				case 2:
				case 4:
					_move_x += (12 * m.rand.next(2));
					if ( _move_x < -12 ) _move_x = -12;
					if ( _move_x >  12 ) _move_x =  12;
					break;
				case 1:
				case 3:
				case 5:
				case 6:
					_move_x += (12 * m.rand.next(3));
					if ( _move_x < -24 ) _move_x = -24;
					if ( _move_x >  24 ) _move_x =  24;
					break;
				case 7:
					_offset_x = (100 * m.rand.next(2));
					break;
				}
			} else if ( (m.level == 7) && (bar > 5) ) {
				if ( m.change_col == 1 ) m.change_col = 2;

				x += _offset_x;
				_offset_x = 0;
			}

			if ( m.change_col == 2 ) {
				m.change_col = 0;

				var old_col = _col;
				_col = m.rand.next(2) + 1;
				if ( _col != old_col ) {
					if ( (m.level < 2) || (m.level == 7) ) {
						// シールド切り替え速度計測開始
						m._elapse_s = 1;

						// シールド変更
						for ( i = 0; i < 2; i++ ) {
							if ( m.shield_wait[i] == 0 ) {
								m.shield_wait[i] = m.shield_lag[i];
								m.shield_col [i] = _col;
							}
						}
					}
				}
			}

			if ( (m.speeder[0]._distance - old_distance) >= 500 ) {
				if ( m.level != 6 ) {
					if ( _DIV(m.speeder[0]._distance, _DIV(DISTANCE, 9)) != _DIV(old_distance, _DIV(DISTANCE, 9)) ) {
						m.wave_add_bar(x, 0, 3, 9 - _DIV(m.speeder[0]._distance, _DIV(DISTANCE, 9)), true);
						if ( (9 - _DIV(m.speeder[0]._distance, _DIV(DISTANCE, 9))) > 0 ) {
							bar = 1;
							counter = true;
							if ( (m.level < 2) || (m.level == 7) ) {
								m.boost = true;
							}
						}
					} else if ( m.speeder[0]._distance < DISTANCE ) {
						bar += _DIV(m.speeder[0]._distance - old_distance, 500);
						x += _move_x;
						m.wave_add_bar(x, 0, _col, 0, false);
					}
				} else {
					bar += _DIV(m.speeder[0]._distance - old_distance, 500);
					x += _move_x;
					m.wave_add_bar(x, 0, _col, 0, false);
				}
				old_distance = m.speeder[0]._distance;
			}
		}
	}

	// ウェーブの色を確認
//	function col() { return _col; }

//	function move_x() { return _move_x; }

//	function offset_x() { return _offset_x; }

	/**
	 * 描画
	 */
	function draw(ready) {
		var i;

		if ( _back < 5 ) {
			g.drawMovie(m.clip_bg[0], 0, 0);
		}

		var distance;
		distance = m.speeder[0]._distance; if ( distance > DISTANCE ) distance = DISTANCE;
		switch ( _back ) {
		case 0:
			g.drawMovie(m.clip_bg[1], 10, _DIV(120 * distance, DISTANCE) - 120);
			break;
		case 1:
			g.drawMovie(m.clip_bg[1], _DIV(120 * distance, DISTANCE) - 120, 0);
			break;
		case 2:
			g.drawMovie(m.clip_bg[1], 0 - _DIV(80 * distance, DISTANCE), 240 - 188);
			break;
		case 3:
			g.drawMovie(m.clip_bg[1], 120 - _DIV(240 * distance, DISTANCE), 0);
			break;
		case 4:
			g.drawMovie(m.clip_bg[1], 0, _DIV(240 * distance, DISTANCE) - 120);
			break;
		case 5:
			g.drawMovie(m.clip_bg[1], 0, _DIV(240 * distance, DISTANCE) - 240);
			break;
		case 6:
			g.drawMovie(m.clip_bg[1], 0 - _DIV(140 * distance, DISTANCE), 0);
			break;
		}

#ifdef USE_STAR
		g.setColor(g.getColorOfRGB(255, 255, 255));
		var h = ready ? 0 : _DIV(m.speeder[0]._speed, 50);
		var tmp;
		for ( i = star.size() - 1; i >= 0; i-- ) {
			tmp = star.elementAt(i);
			if ( (tmp._x >= 0) && (tmp._x < 240) ) {
				g.drawLine(tmp._x, tmp._y, tmp._x, tmp._y + h);
			}
		}
#endif // USE_STAR
	}
}
