#include "_Global.h"

#include "Main.h"

/**
 * スピーダー
 */
class Speeder {
	var m;
	var g;

	var _jiki;	// 自機かどうか
	var _type;		// 種類
	var _auto;		// 自動移動の種類
	var _distance;	// 走行距離
	var _speed;		// スピード
	var _x, off_x;	// 位置
	var _out;	// 画面外かどうか
	var _direction;	// 移動の状態
	var _shield;	// シールドの状態

	/**
	 * コンストラクタ
	 */
	function Speeder(m) {
		this.m = m;
		g = m.g;
	}

	/**
	 * 初期化
	 */
	function init(jiki, type, speed, x) {
		_jiki      = jiki;
		_type      = type;
		_auto      = AUTO_INERTIA;
		_distance  = 0;
		_speed     = speed;
		_x         = x - 12;
		_out       = false;
		_direction = 0;
		_shield    = 0;
	}

	/**
	 * 左移動
	 */
	function left() {
		switch ( _type ) {
		case SPEEDER1: _direction -= 1; break;
		case SPEEDER2: _direction -= 1; break;
		case SPEEDER3: _direction -= 2; break;
		case SPEEDER4: _direction -= 1; break;
		case SPEEDER5: _direction -= 1; break;
		}
		if ( _direction < -15 ) _direction = -15;
		_x += _direction;
	}

	/**
	 * 右移動
	 */
	function right() {
		switch ( _type ) {
		case SPEEDER1: _direction += 1; break;
		case SPEEDER2: _direction += 1; break;
		case SPEEDER3: _direction += 2; break;
		case SPEEDER4: _direction += 1; break;
		case SPEEDER5: _direction += 1; break;
		}
		if ( _direction > 15 ) _direction = 15;
		_x += _direction;
	}

	/**
	 * 慣性移動
	 */
	function inertia(neutral) {
		if ( neutral ) {
			if ( _direction > 0 ) {
				_direction--;
			} else if ( _direction < 0 ) {
				_direction++;
			}
		}
		_x += _direction;
	}

	/**
	 *
	 */
	function set_direction(target) {
		if ( _direction < target ) {
			right();
		} else if ( _direction > target ) {
			left();
		}
	}

	function slide(val) { _x += val; }

	function out(bar_x) {
		off_x = _x - bar_x;
		_out = true;
	}
	function _in(bar_x) {
		if      ( off_x <   0 ) off_x =   0;
		else if ( off_x > 176 ) off_x = 176;
		_x = bar_x + off_x;
		_out = false;
		if ( !_jiki ) {
			_direction = _DIV(m.stage._move_x * 15, 24);
		}
	}
//	function out() { return _out; }

//	function type() { return _type; }

	// 自動移動の種類を変更
//	function auto(type) { _auto = type; }

	// 自動移動の種類を確認
//	function auto() { return _auto; }

	// 走行距離を変更
//	function add_distance(val) { _distance += val; }

	// 走行距離を確認
//	function distance() { return _distance; }

	/**
	 * スピードを上げる
	 */
	function speed_up_v(val) {
		_speed += val;
		if ( _speed > 505 ) _speed = 495;
	}
	function speed_up() {
		switch ( _type ) {
		case SPEEDER1:
		case SPEEDER4:
		case SPEEDER5:
			speed_up_v(5);
			break;
		case SPEEDER2:
			speed_up_v(4);
			break;
		case SPEEDER3:
			speed_up_v(3);
			break;
		}
	}

	/**
	 * スピードを落とす
	 */
	function speed_down_v(val) {
		_speed -= val;
		if ( _speed < 0 ) _speed = 0;
	}
	function speed_down() {
		switch ( _type ) {
		case SPEEDER1:
		case SPEEDER4:
		case SPEEDER5:
			speed_down_v(25);
			break;
		case SPEEDER2:
			speed_down_v(20);
			break;
		case SPEEDER3:
			speed_down_v(25);
			break;
		}
	}

	/**
	 * スピードを制限する
	 */
	function speed_limit(val) {
		if ( _speed > val ) _speed = val;
	}

	// スピードを確認
//	function speed() { return _speed; }

	// シールドの状態を変更
	function shield(col) {
		_shield = col;
		if ( _jiki && (m._elapse_s > 0) && (_shield == m.stage._col) ) {
			if ( m._elapse_s <= 20 ) {
				m.shield_lag[m.shield_index] = _DIV(m.shield_lag[m.shield_index] + m._elapse_s, 2);
				m.shield_index++; if ( m.shield_index > 1 ) m.shield_index = 0;
			}
			m._elapse_s = 0;
		}
	}

	// シールドの状態を確認
//	function shield() { return _shield; }

	// 位置を確認
//	function x() { return _x; }
	function dsp_x() { return _jiki ? 108 : (108 + (_x - m.speeder[0]._x)); }
	function dsp_y() { return _jiki ? 192 : (192 - _DIV(_distance - m.speeder[0]._distance, 10)); }

	// 移動の状態を確認
//	function direction() { return _direction; }

	/**
	 * 描画
	 */
	function draw(ready) {
		var i;

		var x = dsp_x();
		var y = dsp_y();
		if ( y <= -48 ) {
			return;
		}
		if ( _jiki && ((m._elapse - m._elapse_b) < WAIT_BOOST) ) {
			for ( i = 1; i < 10; i++ ) {
				m.drawImage(IMAGE_SHIELD_0 + _shield, x - _DIV(_direction * i, 10), y + _DIV(_speed * i, 50), 24, 24);
			}
		} else if ( !ready && (_MOD(m.elapse(), 2) == 0) ) {
			m.drawImage(IMAGE_SHIELD_6 + _shield, x -      _direction    , y + _DIV(_speed, 10), 24, 48);
			m.drawImage(IMAGE_SHIELD_3 + _shield, x - _DIV(_direction, 2), y + _DIV(_speed, 20), 24, 48);
		}
		m.drawImage(IMAGE_SHIELD_0 + _shield, x, y, 24, 48);
		var d = _direction;
		if ( _direction < 0 ) {
			d = 0 - _direction;
			g.setFlipMode(_FLIP_HORIZONTAL);
		}
		switch ( _type ) {
		case SPEEDER1:
			g.drawImage(IMAGE_SPEEDER1_00 + d,
				x + 12 - _DIV(m.SPEEDER1_W[d], 2), y + 3
				);
			break;
		case SPEEDER2:
		case SPEEDER4:
			g.drawImage(IMAGE_SPEEDER2_00 + d,
				x + 12 - _DIV(m.SPEEDER2_W[d], 2), y + 3
				);
			break;
		case SPEEDER3:
		case SPEEDER5:
			g.drawImage(IMAGE_SPEEDER3_00 + d,
				x + 12 - _DIV(m.SPEEDER3_W[d], 2), y + 3
				);
			break;
		}
		if ( _direction < 0 ) {
			g.setFlipMode(_FLIP_NONE);
		}
	}
}
