#include "_Global.h"

class Main extends _Main
{
	var g:_Graphics;

	var fsc:_FSCommand;
	var rand:_Random;

	var object:_Vector;
	var object1:_Vector;
	var object2:_Vector;

	var key_press:Number;
	var key_release:Number;

	var mouse_sx:Number;
	var mouse_sy:Number;
	var mouse_ex:Number;
	var mouse_ey:Number;
	var mouse:Boolean;

	var sin:Number;
	var sin_f:Boolean;

	var _elapse;	// oߎ
	var _time;		//

	function start():Boolean
	{
		g = getGraphics();

		fsc = new _FSCommand();
		rand = new _Random();

		object = new _Vector( 128 );
		object1 = new _Vector( 128 );
		object2 = new _Vector( 128 );

		key_press = -1;
		key_release = -1;

		mouse = false;

		sin = 0;
		sin_f = true;

		_elapse = 0;
		_time = getTimer();

		return true;
	}

	function paint():Void
	{
		var i:Number;
		var tmp;
		var tmp1:Object;
		var tmp2:MainObject2;

		for( i = 0; i < object.size(); i++ )
		{
			tmp = object.elementAt( i );
			tmp.update();
		}
		for( i = 0; i < object1.size(); i++ )
		{
			tmp1 = object1.elementAt( i );
			tmp1.update();
		}
		for( i = 0; i < object2.size(); i++ )
		{
			tmp2 = MainObject2( object2.elementAt( i ) );
			tmp2.update();
		}

		g.lock();
		g.setColor( g.getColorOfRGB( 127, 127, 127 ) );
		g.fillRect( 0, 0, 240, 240 );
		for( i = 0; i < object.size(); i++ )
		{
			tmp = object.elementAt( i );
			tmp.draw();
		}
		for( i = 0; i < object1.size(); i++ )
		{
			tmp1 = object1.elementAt( i );
			tmp1.draw();
		}
		for( i = 0; i < object2.size(); i++ )
		{
			tmp2 = MainObject2( object2.elementAt( i ) );
			tmp2.draw();
		}
		if( mouse )
		{
			g.setColor( g.getColorOfRGB( 255, 0, 255 ) );
			g.drawLine( mouse_sx, mouse_sy, mouse_ex, mouse_ey );
		}
		g.setColor( g.getColorOfRGB( 255, 0, 0 ) );
		g.setFont( _FONT_TINY );
		g.drawString( "" + ((_elapse + 1) * 1000 / (getTimer() - _time)), 0, 12 );
		g.drawString( "" + (object.size() + object1.size() + object2.size()), 0, 24 );
#ifdef _DEBUG
		g.drawString( "ascii " + _key_ascii, 0, 204 );
#endif // _DEBUG
		g.drawString( "key " + getKeypadState(), 0, 216 );
		g.drawString( "press " + key_press, 0, 228 );
		g.drawString( "release " + key_release, 0, 240 );
		g.unlock();

		if( sin_f )
		{
			if( sin == 1 )
			{
				sin++;
				fsc.startVibrate();
			}
			else if( sin == 2 )
			{
				sin = 0;
				fsc.stopVibrate();
			}
		}
		else
		{
			if( sin > 1 )
			{
				fsc.stopVibrate();
			}
			sin = 0;
		}

		_elapse++;
	}

	function processEvent( type:Number, param:Number ):Void
	{
		switch( type )
		{
		case _KEY_PRESSED_EVENT:
			key_press = param;
			if( param == _KEY_POUND )
			{
				sin_f = sin_f ? false : true;
			}
			else
			{
				if( Number( getParameter( "type" ) ) == 0 )
				{
					object1.addElement( new MainObject1( this,
						120 + (rand.nextInt() % 120),
						120 + (rand.nextInt() % 120),
						rand.nextInt() % 10,
						rand.nextInt() % 10 ) );
				}
				else
				{
					object2.addElement( new MainObject2( this,
						120 + (rand.nextInt() % 120),
						120 + (rand.nextInt() % 120),
						rand.nextInt() % 10,
						rand.nextInt() % 10 ) );
				}
			}
			break;
		case _KEY_RELEASED_EVENT:
			key_release = param;
			break;
		case _MOUSE_DOWN_EVENT:
			mouse_sx = getMouseX();
			mouse_sy = getMouseY();
			mouse = true;
			break;
		case _MOUSE_MOVE_EVENT:
			mouse_ex = getMouseX();
			mouse_ey = getMouseY();
			break;
		case _MOUSE_UP_EVENT:
			mouse_ex = getMouseX();
			mouse_ey = getMouseY();
			mouse = false;
			object.addElement( new MainObject( this,
				mouse_ex,
				mouse_ey,
				mouse_sx - mouse_ex,
				mouse_sy - mouse_ey,
				Number( getParameter( "type" ) ) ) );
			break;
		}
	}
}
