#include "_Global.h"

class Main extends _Main
{
	var g:_Graphics;

	var key_press:Number;
	var key_release:Number;

	var softkey:_SoftKey;

	function start():Boolean
	{
		g = getGraphics();

		key_press = -1;
		key_release = -1;

		softkey = new _SoftKey( 12 );
		softkey.add(  40,  20, 40, 40, _KEY_1, 49 );
		softkey.add( 100,  20, 40, 40, _KEY_2, 50 );
		softkey.add( 160,  20, 40, 40, _KEY_3, 51 );
		softkey.add(  40,  70, 40, 40, _KEY_4, 52 );
		softkey.add( 100,  70, 40, 40, _KEY_5, 53 );
		softkey.add( 160,  70, 40, 40, _KEY_6, 54 );
		softkey.add(  40, 120, 40, 40, _KEY_7, 55 );
		softkey.add( 100, 120, 40, 40, _KEY_8, 56 );
		softkey.add( 160, 120, 40, 40, _KEY_9, 57 );
		softkey.add(  40, 170, 40, 40, _KEY_ASTERISK, 42 );
		softkey.add( 100, 170, 40, 40, _KEY_0, 48 );
		softkey.add( 160, 170, 40, 40, _KEY_POUND, 35 );
		setSoftKey( softkey );

		return true;
	}

	function paint():Void
	{
		var i;
		var left;
		var top;
		var width;
		var height;
		var str;

		g.lock();

		g.setColor( g.getColorOfRGB( 127, 127, 127 ) );
		g.fillRect( 0, 0, 240, 240 );

		g.setColor( g.getColorOfRGB( 0, 0, 255 ) );
		g.setFont( _FONT_SMALL );
		for( i = 0; i < softkey.num(); i++ )
		{
			left   = softkey.left  ( i );
			top    = softkey.top   ( i );
			width  = softkey.width ( i );
			height = softkey.height( i );
			g.drawRect( left, top, width - 1, height - 1 );
			str = "";
			switch( softkey.code( i ) )
			{
			case _KEY_0        : str = "0"; break;
			case _KEY_1        : str = "1"; break;
			case _KEY_2        : str = "2"; break;
			case _KEY_3        : str = "3"; break;
			case _KEY_4        : str = "4"; break;
			case _KEY_5        : str = "5"; break;
			case _KEY_6        : str = "6"; break;
			case _KEY_7        : str = "7"; break;
			case _KEY_8        : str = "8"; break;
			case _KEY_9        : str = "9"; break;
			case _KEY_POUND    : str = "#"; break;
			case _KEY_ASTERISK : str = "*"; break;
			}
			if( (getKeypadState() & keyBit( softkey.code( i ) )) != 0 )
			{
				g.fillRect( left, top, width, height );
			}
			else
			{
				g.drawString(
					str,
					left + _DIV( width - g.stringWidth( str ), 2 ),
					top + _DIV( height - g.fontHeight(), 2 ) + g.fontHeight() );
			}
		}

		g.setColor( g.getColorOfRGB( 255, 0, 0 ) );
		g.setFont( _FONT_TINY );
		g.drawString( "key " + getKeypadState(), 0, 12 );
		g.drawString( "press " + key_press, 0, 24 );
		g.drawString( "release " + key_release, 0, 36 );

		g.unlock();
	}

	function processEvent( type:Number, param:Number ):Void
	{
		switch( type )
		{
		case _KEY_PRESSED_EVENT:
			key_press = param;
			break;
		case _KEY_RELEASED_EVENT:
			key_release = param;
			break;
		}
	}
}
